import {connect} from 'react-redux';
import {SignUp} from './SignUp.jsx';
import {getLanguage, getTrackId} from '@blocks/selectors';

const mapStateToProps = (state = {}) => {
    const {signup = {}, common = {}} = state;
    const {mode} = signup;
    const {dev: isDev} = common;

    return {
        mode,
        trackId: getTrackId(state, 'register'),
        language: getLanguage(state),
        isDev
    };
};

const ConnectedSignUp = connect(mapStateToProps)(SignUp);

export {ConnectedSignUp as SignUp};
export default ConnectedSignUp;
