import './RegistrationWithSuggestToRestoreByPhone.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {STEPS, STEP_SCREENS, getNextStep} from './config';
import {Accounts} from '@screens/Accounts';
import {GlobalError} from '@screens/GlobalError';
import {initSignUpObserver, stopSignUpObserver} from './yabroApi';
import metrika from '@blocks/metrics';

const b = cn('RegistrationWithSuggestToRestoreByPhone');

class RegistrationWithSuggestToRestoreByPhone extends React.PureComponent {
    componentDidMount() {
        const {getPersonalData, envType, debug, mode, isRegAfterAuthStart} = this.props;

        initSignUpObserver({envType, debug});
        getPersonalData();

        if (isRegAfterAuthStart) {
            return metrika.setHeader('Авторизация');
        }

        metrika.setHeader(`Регистрация ${mode}`);
        metrika.send(`Показ регистрации ${mode}`);
    }

    componentWillUnmount() {
        stopSignUpObserver();
    }

    _onNext = (event) => {
        const {step, onNext} = this.props;

        if (event) {
            event.preventDefault();
        }

        onNext(step);
    };

    _onBack = () => {
        const {step, onBack} = this.props;

        onBack(step);
    };

    _continueRegistration = () => {
        const {step, onContinueRegistration} = this.props;

        onContinueRegistration(getNextStep(step));
    };

    _getStepBody = () => {
        const {suggestToRestore, processError = {}, accounts = []} = this.props;

        if (processError.status && processError.status !== 'ok') {
            return this._renderError();
        }

        if (suggestToRestore && accounts.length) {
            return this._renderAccounts();
        }

        return this._renderFormStep();
    };

    _getScreen = () => {
        const {step, mode, retryToRequestPhoneConfirmationCode} = this.props;
        const Screen = STEP_SCREENS[step];
        const props = {
            place: mode
        };

        if (['phoneConfirm', 'eula'].includes(step)) {
            props.goBack = this._onBack;
        }

        if (step === 'phoneConfirm') {
            props.onRetry = retryToRequestPhoneConfirmationCode;
        }

        return <Screen onConfirm={this._onNext} {...props} />;
    };

    _renderFormStep = () => {
        const {formUrl, trackId} = this.props;

        return (
            <form autoComplete='off' action={formUrl} method='post' onSubmit={this._onNext} className={b('form')}>
                <input name='track_id' id='track_id' type='hidden' value={trackId} />
                {this._getScreen()}
            </form>
        );
    };

    _renderAccounts = () => <Accounts onContinue={this._continueRegistration} place={this.props.mode} />;

    _renderError = () => {
        const {restartRegistration, processError, mode} = this.props;

        return <GlobalError onRestart={restartRegistration} error={processError} place={mode} />;
    };

    render() {
        return (
            <div className={b()} id={b()}>
                {this._getStepBody()}
            </div>
        );
    }
}

RegistrationWithSuggestToRestoreByPhone.propTypes = {
    step: PropTypes.oneOf(STEPS).isRequired,
    onNext: PropTypes.func.isRequired,
    onBack: PropTypes.func.isRequired,
    onContinueRegistration: PropTypes.func.isRequired,
    retryToRequestPhoneConfirmationCode: PropTypes.func.isRequired,
    trackId: PropTypes.string.isRequired,
    formUrl: PropTypes.string.isRequired,
    mode: PropTypes.string,
    accounts: PropTypes.array,
    suggestToRestore: PropTypes.bool,
    processError: PropTypes.shape({
        status: PropTypes.string,
        text: PropTypes.string
    }),
    getPersonalData: PropTypes.func.isRequired,
    envType: PropTypes.string,
    debug: PropTypes.bool,
    restartRegistration: PropTypes.func.isRequired,
    isRegAfterAuthStart: PropTypes.bool
};

export {RegistrationWithSuggestToRestoreByPhone};
