import {Login} from '@screens/SignUp/Login';
import {PhoneConfirmation} from '@screens/PhoneConfirmation';
import {PersonalData} from '@screens/SignUp/PersonalData';
import {Eula} from '@screens/SignUp/Eula';
import {Finish} from '@screens/SignUp/Finish';

export const STEPS = ['personalData', 'phoneConfirm', 'login', 'eula', 'finish'];

export const STEP_SCREENS = {
    personalData: PersonalData,
    phoneConfirm: PhoneConfirmation,
    login: Login,
    finish: Finish,
    eula: Eula
};

export const STEP_FIELDS = {
    personalData: ['firstname', 'lastname', 'phone'],
    login: ['login']
};

export const getNextStep = (step) => STEPS[STEPS.indexOf(step) + 1];
export const getPrevStep = (step) => STEPS[STEPS.indexOf(step) - 1];
