import {TRACK_TYPES} from '@blocks/actions/tracks';
import {connect} from 'react-redux';
import {RegistrationWithSuggestToRestoreByPhone} from './RegistrationWithSuggestToRestoreByPhone.jsx';
import {onNext, onBack, getPersonalData} from './logic';
import {onContinueRegistration, restartRegistration} from '@blocks/SignUp/utils';
import {retryToRequestPhoneConfirmationCode} from '@blocks/actions/phoneConfirm';
import {getTrackId} from '@blocks/selectors';
import {STEPS} from './config';

const mapStateToProps = (state = {}) => {
    const {signup = {}, userEntryFlow = {}, common = {}, settings = {}, accountsSuggest = {}} = state;
    const {processError, isRegAfterAuthStart} = userEntryFlow;
    const {step, suggestToRestore, mode} = signup;
    const {accounts} = accountsSuggest;
    const {debug} = common;
    const {formUrl, env = {}} = settings;
    const {type: envType} = env;

    return {
        step: step || STEPS[0],
        trackId: getTrackId(state, TRACK_TYPES.REGISTER),
        formUrl,
        accounts,
        suggestToRestore,
        mode,
        isRegAfterAuthStart,
        processError,
        envType,
        debug
    };
};

const mapDispatchToProps = {
    onNext,
    onBack,
    onContinueRegistration,
    getPersonalData,
    retryToRequestPhoneConfirmationCode,
    restartRegistration
};

const Connected = connect(mapStateToProps, mapDispatchToProps)(RegistrationWithSuggestToRestoreByPhone);

export {Connected as RegistrationWithSuggestToRestoreByPhone};
