/* global yandex */

// Оповещает браузер, что аккаунт создан успешно.
// yandex.fastSignup.accountCreated();

// Закрывает балун, кликом в кнопку Хорошо.
// yandex.fastSignup.closeBalloon();

// Задает высоту webview балуна.
// yandex.fastSignup.setBalloonHeight(600);

// Генерит пароль (временно храня его в оперативной памяти на стороне C++ для дальнейшего сохранения в passman).
// Каждый следующий вызов затирает предыдущее временное значение пароля на стороне C++.
// yandex.fastSignup.generatePassword(function (password) { console.log(password); });

// Сохраняет в passman пару логин/пароль (который временно хранился с момента вызова generatePassword()).
// yandex.fastSignup.saveSignupDataForLogin('user1');

// Открывает страницу с паролями.
// yandex.fastSignup.showPasswordList();

// Имя + Фамилия.
// yandex.fastSignup.getFullName(function (name) { console.log(name); });

// Телефон.
// yandex.fastSignup.getPhone(function (phone) { console.log(phone); });

import {suggestPassword, updateValues} from '@blocks/actions/form';

class YaBroSignUpApi {
    constructor() {
        this.isYaBroApiAvailable = typeof window !== 'undefined' && Boolean(window.yandex && window.yandex.fastSignup);
    }

    initDebugApi({envType, debug}) {
        if (!['testing', 'development'].includes(envType) || !debug || this.isYaBroApiAvailable) {
            return;
        }

        /* eslint-disable no-console */

        if (typeof window === 'undefined') {
            return;
        }

        const root = document.getElementById('root');

        root.style.border = '1px solid red';
        root.style.minHeight = 'auto';

        this.isYaBroApiAvailable = true;
        window.yandex = {};
        window.yandex.fastSignup = {
            accountCreated: () => console.log('accountCreated'),
            closeBalloon: () => console.log('closeBalloon'),
            setBalloonHeight: (height) => {
                root.style.height = `${height}px`;
            },
            generatePassword: (callback) => {
                callback(
                    `generated${Math.random()
                        .toString()
                        .slice(0, 6)}`
                );
            },
            saveSignupDataForLogin: () => console.log('saveSignupDataForLogin'),
            showPasswordList: () => console.log('showPasswordList'),
            getFullName: (callback) => {
                callback('John', 'Doe');
            },
            getPhone: (callback) => {
                callback('+79000000000');
            }
        };

        /* eslint-enable no-console */
    }

    getSignUpLayoutHeight() {
        if (!this.signUpLayout) {
            this.signUpLayout =
                typeof window !== 'undefined' && document.getElementById('RegistrationWithSuggestToRestoreByPhone');
        }

        const layout = this.signUpLayout;
        const rect =
            (layout && typeof layout.getBoundingClientRect === 'function' && layout.getBoundingClientRect()) || {};

        return Math.ceil(rect.height || 0);
    }

    saveSignupDataForLogin(login) {
        if (!this.isYaBroApiAvailable) {
            return;
        }

        yandex.fastSignup.saveSignupDataForLogin(login);
    }

    showPasswordList() {
        if (!this.isYaBroApiAvailable) {
            return;
        }

        yandex.fastSignup.showPasswordList();
    }

    closeBalloon() {
        if (!this.isYaBroApiAvailable) {
            return;
        }

        yandex.fastSignup.closeBalloon();
    }

    generatePassword(callback) {
        if (!this.isYaBroApiAvailable) {
            return;
        }

        yandex.fastSignup.generatePassword(callback);
    }

    getPersonalData(callback) {
        if (!this.isYaBroApiAvailable) {
            return;
        }

        yandex.fastSignup.getFullName((firstName = '', lastName = '') => {
            yandex.fastSignup.getPhone((phone = '') => {
                callback({firstName, lastName, phone});
            });
        });
    }

    updateBalloonHeight() {
        if (!this.isYaBroApiAvailable) {
            return;
        }

        yandex.fastSignup.setBalloonHeight(this.getSignUpLayoutHeight() + 30); // ¯\_(ツ)/¯
    }

    initSignUpObserver() {
        if (!this.isYaBroApiAvailable) {
            return;
        }

        this.updateBalloonHeight();

        const callback = (mutationsList) => {
            for (const mutation of mutationsList) {
                if (mutation.type === 'childList') {
                    this.updateBalloonHeight();
                }
            }
        };

        // eslint-disable-next-line compat/compat
        this.observer = new MutationObserver(callback);
        this.observer.observe(this.signUpLayout, {
            childList: true,
            subtree: true
        });
    }

    stopSignUpObserver() {
        if (this.observer) {
            this.observer.disconnect();
        }
    }
}

const api = new YaBroSignUpApi();

const initSignUpObserver = (params) => {
    // DEBUG MODE
    api.initDebugApi(params);
    api.initSignUpObserver();
};

const stopSignUpObserver = () => api.stopSignUpObserver();
const closeBalloon = () => api.closeBalloon();
const showPasswordList = () => api.showPasswordList();
const generatePassword = () => (dispatch) =>
    api.generatePassword((password) => {
        dispatch(suggestPassword(password));
        dispatch(updateValues({field: 'password', value: password}));
    });

export {
    api as YaBroSignUpApi,
    stopSignUpObserver,
    initSignUpObserver,
    closeBalloon,
    showPasswordList,
    generatePassword
};
