import {
    CHANGE_SIGN_UP_STEP,
    SET_SUGGEST_TO_RESTORE_ACCOUNTS,
    SET_REGISTER_MODE,
    CLEAR_SIGN_UP_STATE
} from '@blocks/SignUp/actions';

const initialState = {
    mode: '',
    step: '',
    suggestToRestore: false
};

const signup = (state = initialState, action = {}) => {
    const {type, payload = {}} = action;

    switch (type) {
        case CHANGE_SIGN_UP_STEP: {
            const {step} = payload;

            return Object.assign({}, state, {step});
        }

        case SET_SUGGEST_TO_RESTORE_ACCOUNTS: {
            const {suggestToRestore} = payload;

            return Object.assign({}, state, {suggestToRestore});
        }

        case SET_REGISTER_MODE: {
            const {mode} = payload;

            return Object.assign({}, state, {mode});
        }

        case CLEAR_SIGN_UP_STATE: {
            return Object.assign({}, state, {step: '', suggestToRestore: false});
        }

        default: {
            return state;
        }
    }
};

export default signup;
