import api from '@blocks/api';
import {domikIsLoading} from '@blocks/auth/actions';
import {updateValues} from '@blocks/actions/form';
import {clearProcessError, setProcessError} from '@blocks/UserEntryFlow/actions';
import {changeSignUpStep, setSuggestToRestoreAccount} from './actions';
import {toggleBackPaneVisibility} from '@blocks/common/actions';
import {getSuggestedLogins} from '@components/LoginSuggest/actions';
import metrika from '@blocks/metrics';
import {getError} from '@blocks/utils';

const onContinueRegistration = (step) => (dispatch, getState) => {
    const state = getState();

    dispatch(domikIsLoading(true));
    getSuggestedLogins(dispatch, state, true).then(() => {
        dispatch(domikIsLoading(false));
        dispatch(changeSignUpStep(step));
        dispatch(setSuggestToRestoreAccount(false));
    });
};

const restartRegistration = () => (dispatch, getState) => {
    const state = getState();
    const {tracks = {}} = state;
    const {registerTrackId: trackId} = tracks;

    metrika.send('Клик в "Попробовать еще раз"');
    api.getTrack({trackId, type: 'register', scenario: 'register'}).then((response = {}) => {
        const {id} = response;

        if (id) {
            dispatch(clearProcessError());
            dispatch(updateValues({field: 'login', value: ''}));
            dispatch(updateValues({field: 'password', value: ''}));
            dispatch(changeSignUpStep(''));
            dispatch(toggleBackPaneVisibility(true));
            return;
        }

        const error = getError('registration', 'global');
        const regError = Object.assign({}, error, {
            status: 'error',
            descriptionText: error.errorDescription
        });

        metrika.send(`Ошибка регистрации no_track`);
        dispatch(setProcessError(regError));
    });
};

export {onContinueRegistration, restartRegistration};
