import './Social.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Logo} from '@components/Logo';
import {NoJS} from '@components/NoJS';
import {CallBack} from '@screens/Social/CallBack';
import {Register} from '@screens/Social/Register';
import {Error} from '@screens/Social/Error';
import {Redirector} from '@screens/Social/Redirector';
import {InitSuggest} from '@screens/Social/InitSuggest';

const b = cn('Social');

class Social extends React.PureComponent {
    getScreen = () => {
        const {screen} = this.props;

        switch (screen) {
            case 'redirector': {
                return <Redirector />;
            }

            case 'callback': {
                return <CallBack />;
            }

            case 'register': {
                return <Register />;
            }

            case 'error': {
                return <Error />;
            }

            case 'suggest': {
                return <InitSuggest />;
            }

            default: {
                return null;
            }
        }
    };

    render() {
        return (
            <>
                <NoJS />
                <div className={b()}>
                    <div className={b('header')}>
                        <Logo isStatic={true} />
                    </div>
                    <div className={b('body')}>{this.getScreen()}</div>
                </div>
            </>
        );
    }
}

Social.propTypes = {
    screen: PropTypes.oneOf(['redirector', 'callback', 'error', 'register', 'suggest']).isRequired,
    language: PropTypes.string.isRequired
};

export {Social};
