import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import {push} from 'connected-react-router';
import metrics from '@blocks/metrics';
import {Button} from '@components/Button';
import {Checkbox} from '@components/Checkbox';
import {RadioButton} from '@components/RadioButton';
import ReturnToService from '@components/ReturnToService/ReturnToService.jsx';
import {SubsList} from './SubsList';
import {SubsNoActualView} from './SubsNoActualView';
import {cn} from '@bem-react/classname';

import './Subs.styl';
import {sendData} from './actions/sendData';
import {getSubsList} from './actions/getSubsList';
import {toggleListType, toggleAll} from './actions';

const b = cn('Subs');

const PROFILE_URL = '/profile';
const RADIO_BUTTON_OPTIONS = [
    {
        value: 'actual',
        children: i18n('Profile2.subs.radio-button-value-active'),
        'data-t': 'radiobutton:list:actual'
    },
    {
        value: 'all',
        children: i18n('Profile2.subs.radio-button-value-all'),
        'data-t': 'radiobutton:list:all'
    }
];

class Subs extends Component {
    componentDidMount() {
        const {subs, getSubsList} = this.props;

        if (subs.list.length === 0) {
            getSubsList();
        }

        metrics.send(['Управление рассылками', 'Открыли форму']);
    }

    componentDidUpdate(prevProps) {
        const {subs, isMobile, isModal, dispatch} = this.props;
        const {hasChanged} = subs;

        if (!prevProps.subs.hasChanged && hasChanged) {
            if (isMobile && dispatch) {
                dispatch(push(PROFILE_URL));
                return;
            }

            if (!isModal) {
                location.href = PROFILE_URL;
            }
        }
    }

    handleRadio = (event) => {
        const {toggleListType} = this.props;

        toggleListType(event.target.value);

        if (event.target.value === 'all') {
            metrics.send(['Управление рассылками', 'Перешли во Все сервисы']);
        }
    };

    selectAll = () => {
        const {subs, toggleAll} = this.props;
        const {listType, hasAllChecked, hasAllActualChecked} = subs;

        if (listType === 'all') {
            toggleAll(!hasAllChecked);
            return;
        }
        toggleAll(!hasAllActualChecked);
    };

    handleSubmit = (event) => {
        event.preventDefault();
        this.props.sendData();
    };

    render() {
        const {subs, isMobile, retpath, isModal} = this.props;
        const {
            list,
            actualList,
            hasAllChecked,
            hasAllActualChecked,
            hasAllUnchecked,
            hasAllActualUnchecked,
            error,
            listType,
            wasListLoad
        } = subs;
        const isNoActualView = wasListLoad && actualList.length === 0 && listType === 'actual';
        const currentList = listType === 'actual' ? actualList : list;
        const hasAllCheckedOnCurList =
            (listType === 'actual' && hasAllActualChecked) || (listType === 'all' && hasAllChecked);
        const hasAllUncheckedOnCurList =
            (listType === 'actual' && hasAllActualUnchecked) || (listType === 'all' && hasAllUnchecked);

        return (
            <div className={b('wrap', {wide: !isModal})}>
                <div className={b('layout', {wide: !isModal})}>
                    {!isModal && (
                        <ReturnToService
                            className={b('returnButton')}
                            retpath={retpath}
                            pathTo='/profile'
                            useHref={true}
                        />
                    )}

                    <h2 className={b('titleLarge', {paddingTopNone: isModal})}>{i18n('Profile2.subs.title')}</h2>
                    <div className={b('descr')}>{i18n('Profile2.subs.description.v2')}</div>

                    <RadioButton
                        size='m'
                        view='default'
                        value={listType}
                        className={b('radioButton')}
                        options={RADIO_BUTTON_OPTIONS}
                        onChange={this.handleRadio}
                    />

                    {!isNoActualView && listType === 'all' && (
                        <div className={b('descr')}>{i18n('Profile2.subs.description-all')}</div>
                    )}

                    {!isNoActualView && listType === 'actual' && (
                        <div className={b('descr')}>{i18n('Profile2.subs.description-active')}</div>
                    )}

                    {!isNoActualView && (
                        <div className={b('selectAll')}>
                            <div className={b('selectAllCheck')} onClick={this.selectAll}>
                                {!hasAllCheckedOnCurList && !hasAllUncheckedOnCurList && (
                                    <div className={b('selectAllIconLine')} />
                                )}

                                {(hasAllCheckedOnCurList || hasAllUncheckedOnCurList) && (
                                    <Checkbox
                                        view='yellow'
                                        className={b('checkbox', {decorative: true})}
                                        size='m'
                                        checked={hasAllCheckedOnCurList}
                                    />
                                )}
                            </div>

                            <Button
                                dataT='select-all'
                                aria-checked-all={hasAllCheckedOnCurList}
                                aria-unchecked-all={hasAllUncheckedOnCurList}
                                aria-checked-some={!hasAllCheckedOnCurList && !hasAllUncheckedOnCurList}
                                size={isMobile ? 'm' : 'l'}
                                view='link'
                                type='button'
                                onClick={this.selectAll}
                                className={b('selectAllButton')}
                            >
                                {i18n('Profile2.subs.select_all')}
                            </Button>
                        </div>
                    )}

                    {isNoActualView && <SubsNoActualView />}

                    <form action='#' method='post' onSubmit={this.handleSubmit} id='subs-form'>
                        <SubsList currentList={currentList} wasListLoad={wasListLoad} isModal={isModal} />

                        {!isNoActualView && (
                            <div className={b('submit', {wide: !isModal})}>
                                <Button
                                    dataT='save-changes'
                                    size={isMobile ? 'm' : 'l'}
                                    view='action'
                                    type='submit'
                                    onClick={this.handleSubmit}
                                >
                                    {i18n('_AUTH_.common.save')}
                                </Button>
                            </div>
                        )}

                        {error && (
                            <div className={b('messages')}>
                                <div className={b('error')}>{error}</div>
                            </div>
                        )}
                    </form>
                </div>
            </div>
        );
    }
}

Subs.propTypes = {
    sendData: PropTypes.func.isRequired,
    subs: PropTypes.object,
    isMobile: PropTypes.bool,
    isModal: PropTypes.bool,
    retpath: PropTypes.string,
    dispatch: PropTypes.func,
    getSubsList: PropTypes.func.isRequired,
    toggleAll: PropTypes.func.isRequired,
    toggleListType: PropTypes.func.isRequired
};

const mapStateToProps = function(state = {}) {
    const {subs, settings = {}, common = {}} = state;
    const {ua = {}} = settings;
    const {retpath} = common;

    return {
        subs,
        isMobile: !ua.isTablet && (ua.isMobile || ua.isTouch),
        retpath: retpath
    };
};

const mapDispatchToProps = {
    toggleListType,
    sendData,
    getSubsList,
    toggleAll
};

const ConnectedSubs = connect(mapStateToProps, mapDispatchToProps)(Subs);

export {ConnectedSubs as Subs};
