import React from 'react';
import {useSelector, useDispatch, shallowEqual} from 'react-redux';
import PropTypes from 'prop-types';
import {Spin} from '@components/Spin';
import {Checkbox} from '@components/Checkbox';
import {cn} from '@bem-react/classname';
import {toggleServiceSubscribed, setSubsChanged, setSubsError} from './actions';

import './Subs.styl';

const b = cn('SubsList');

export const SubsList = ({currentList, wasListLoad, isModal}) => {
    const subs = useSelector((state) => state.subs, shallowEqual);

    const dispatch = useDispatch();

    const handleToggle = (event) => {
        const checkedId = event && event.target.id;

        dispatch(toggleServiceSubscribed(checkedId));
        dispatch(setSubsError(null));

        if (subs.hasChanged) {
            dispatch(setSubsChanged(false));
        }
    };

    return (
        <div className={b({wide: !isModal})}>
            {currentList.length
                ? currentList.map((item) => {
                      return (
                          <div key={item.id} className={b('item', {wide: !isModal})}>
                              <Checkbox
                                  view='yellow'
                                  className={b('checkbox')}
                                  size='m'
                                  id={item.id}
                                  name='subscribe'
                                  checked={item.isSubscribed}
                                  onChange={handleToggle}
                              />
                              <label className={b('label')} htmlFor={item.id}>
                                  {item.name}
                              </label>
                          </div>
                      );
                  })
                : !wasListLoad && <Spin progress={true} size='m' />}
        </div>
    );
};

SubsList.propTypes = {
    currentList: PropTypes.array.isRequired,
    wasListLoad: PropTypes.bool.isRequired,
    isModal: PropTypes.bool.isRequired
};
