import React, {PureComponent} from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';
import {Subs} from './Subs.jsx';
import {Link} from '@components/Link';
import {setEditMode} from '@blocks/common/actions';
import Modal from '@components/Wrappers/Modal.jsx';
import {setSubsChanged, resetSubs} from '@blocks/Subs/actions';
import {push} from 'connected-react-router';
import {cn} from '@bem-react/classname';
import './Subs.styl';

const b = cn('SubsModal');

class SubsModal extends PureComponent {
    componentDidUpdate(prevProps) {
        if (!prevProps.hasChanged && this.props.hasChanged) {
            this.closeModal();
        }
    }

    closeModal = () => {
        const {setEditMode, setSubsChanged, resetSubs} = this.props;

        setEditMode('');
        setSubsChanged(false);
        resetSubs();
    };

    openModal = () => {
        const {isMobile, setEditMode, retpath, dispatch} = this.props;

        if (isMobile) {
            let redirectUrl = '/profile/subs';

            if (retpath) {
                redirectUrl += `?retpath=${encodeURIComponent(retpath)}`;
            }

            dispatch(push(redirectUrl));
            return;
        }

        setEditMode('SUBS');
    };

    render() {
        const {isOpened, dispatch} = this.props;

        return (
            <div data-t='subs-modal-block'>
                <div className='s-block__sub s-block__sub_hl'>
                    <Link pseudo={true} onClick={this.openModal}>
                        {i18n('Profile2.subs.title')}
                    </Link>
                </div>
                <Modal visible={isOpened} dataT='subs-modal' onCloserClick={this.closeModal} className={b}>
                    {isOpened && (
                        <Subs isModal={true} closeModal={this.closeModal} dispatch={dispatch} isOpened={isOpened} />
                    )}
                </Modal>
            </div>
        );
    }
}

SubsModal.propTypes = {
    isOpened: PropTypes.bool.isRequired,
    isMobile: PropTypes.bool,
    retpath: PropTypes.string,
    setEditMode: PropTypes.func.isRequired,
    dispatch: PropTypes.func.isRequired,
    hasChanged: PropTypes.bool,
    setSubsChanged: PropTypes.func.isRequired,
    resetSubs: PropTypes.func.isRequired
};

const mapStateToProps = (state = {}) => {
    const {common = {}, settings = {}, subs = {}} = state;
    const {edit, retpath} = common;

    return {
        isOpened: edit === 'SUBS',
        isMobile: settings.isPhone,
        retpath,
        hasChanged: subs.hasChanged
    };
};

const mapDispatchToProps = {
    setEditMode,
    setSubsChanged,
    resetSubs
};

const ConnectedSubsModal = connect(mapStateToProps, mapDispatchToProps)(SubsModal);

export {ConnectedSubsModal as SubsModal};
