import api from '@blocks/api';
import {setSubsError, updateSubsList} from '@blocks/Subs/actions';
import {handleError} from '@blocks/Subs/actions/handleError';

export function getSubsList() {
    return function(dispatch) {
        api.request('subs-list')
            .done((result = {}) => {
                if (result.status === 'ok') {
                    const list = [...(result.list || [])];
                    const actualList = [...list].filter((item) => item.emailSentTs > 0 && item.isSubscribed);
                    const hasAllChecked = list.every((item) => item.isSubscribed);
                    const hasAllActualChecked = actualList.every((item) => item.isSubscribed);
                    const hasAllUnchecked = list.every((item) => !item.isSubscribed);
                    const hasAllActualUnchecked = actualList.every((item) => !item.isSubscribed);

                    const options = {
                        list,
                        actualList,
                        hasAllChecked,
                        hasAllActualChecked,
                        hasAllUnchecked,
                        hasAllActualUnchecked
                    };

                    dispatch(updateSubsList(options));
                    return;
                }

                dispatch(setSubsError(handleError()));
            })
            .fail(() => {
                dispatch(setSubsError(handleError()));
            });
    };
}
