import api from '@blocks/api';
import metrics from '@blocks/metrics';
import {setSubsChanged, setSubsError} from './index';
import {handleError} from './handleError';

export function sendData() {
    return function(dispatch, getState) {
        const {subs = {}} = getState();
        const data = {};
        const metricsSubList = [];
        const metricsUnsubList = [];

        subs.list.forEach((item) => {
            data[item.id] = item.isSubscribed;

            if (item.hasChanged) {
                item.isSubscribed ? metricsSubList.push(item.name) : metricsUnsubList.push(item.name);
            }
        });

        api.request('subs-submit', {services: JSON.stringify(data)})
            .done((response = {}) => {
                if (response.status === 'ok') {
                    metricsSubList.forEach((elem) =>
                        metrics.send(['Управление рассылками', 'Подписались:', `${elem}`])
                    );
                    metricsUnsubList.forEach((elem) =>
                        metrics.send(['Управление рассылками', 'Отписались:', `${elem}`])
                    );

                    dispatch(setSubsChanged(true));
                    return;
                }

                dispatch(setSubsError());
            })
            .fail((error = {}) => {
                dispatch(setSubsError(handleError(error.error || error.errors)));
            });
    };
}
