import {combineReducers} from 'redux';
import header from '@blocks/morda/components/header/reducers';
import common from '@blocks/common/reducers';
import isLoading from '@blocks/reducers/spin';
import {
    SUBS_TOGGLE_SUBSCRIBED,
    SUBS_TOGGLE_ALL,
    SUBS_GET_LIST,
    SUBS_CHANGED,
    SUBS_ERROR,
    SUBS_TOGGLE_LIST_TYPE,
    SUBS_RESET
} from './actions';

const initialState = {
    list: [],
    actualList: [],
    error: null,
    hasChanged: false,
    hasAllChecked: true,
    hasAllActualChecked: true,
    hasAllUnchecked: false,
    hasAllActualUnchecked: false,
    listType: 'actual',
    wasListLoad: false
};
const stub = (state = {}) => state;
const rootReducer = combineReducers({
    common,
    header,
    person: stub,
    access: stub,
    settings: stub,
    footer: stub,
    metrics: stub,
    monitoring: stub,
    isLoading,
    tracks: stub,
    subs
});

export default rootReducer;

export function subs(state = initialState, action = {}) {
    switch (action.type) {
        case SUBS_TOGGLE_LIST_TYPE: {
            return {
                ...state,
                listType: action.listType
            };
        }
        case SUBS_TOGGLE_SUBSCRIBED: {
            const indexOfCurElement = state.list.findIndex((el) => el.id === action.id);
            const newValue = !state.list[indexOfCurElement].isSubscribed;

            const updatedArrActual = state.actualList.map((item) => {
                if (item.id === action.id) {
                    return {...item, isSubscribed: newValue};
                }

                return item;
            });

            const updatedArrAll = state.list.map((item) => {
                if (item.id === action.id) {
                    return {...item, isSubscribed: newValue, hasChanged: !item.hasChanged};
                }

                return item;
            });

            return {
                ...state,
                actualList: updatedArrActual,
                list: updatedArrAll,
                hasAllChecked: updatedArrAll.every((item) => item.isSubscribed),
                hasAllActualChecked: updatedArrActual.every((item) => item.isSubscribed),
                hasAllUnchecked: updatedArrAll.every((item) => !item.isSubscribed),
                hasAllActualUnchecked: updatedArrActual.every((item) => !item.isSubscribed)
            };
        }
        case SUBS_TOGGLE_ALL: {
            const updatedArrActual = state.actualList.map((el) => ({...el, isSubscribed: action.isSubscribed}));

            let updatedArrAll = [];

            if (state.listType === 'actual') {
                updatedArrAll = state.list.map((el) => {
                    const indexInActual = updatedArrActual.findIndex((item) => el.id === item.id);
                    const hasChanged = el.isSubscribed === action.isSubscribed ? el.hasChanged : !el.hasChanged;

                    if (indexInActual >= 0) {
                        return {...el, isSubscribed: action.isSubscribed, hasChanged};
                    }
                    return el;
                });
            }

            if (state.listType === 'all') {
                updatedArrAll = state.list.map((el) => {
                    const hasChanged = el.isSubscribed === action.isSubscribed ? el.hasChanged : !el.hasChanged;

                    return {...el, isSubscribed: action.isSubscribed, hasChanged};
                });
            }

            return {
                ...state,
                list: updatedArrAll,
                actualList: updatedArrActual,
                hasAllChecked: updatedArrAll.every((item) => item.isSubscribed),
                hasAllActualChecked: updatedArrActual.every((item) => item.isSubscribed),
                hasAllUnchecked: updatedArrAll.every((item) => !item.isSubscribed),
                hasAllActualUnchecked: updatedArrActual.every((item) => !item.isSubscribed)
            };
        }
        case SUBS_GET_LIST: {
            return {
                ...state,
                list: action.options.list,
                actualList: action.options.actualList,
                hasAllChecked: action.options.hasAllChecked,
                hasAllActualChecked: action.options.hasAllActualChecked,
                hasAllUnchecked: action.options.hasAllUnchecked,
                hasAllActualUnchecked: action.options.hasAllActualUnchecked,
                wasListLoad: true
            };
        }
        case SUBS_ERROR: {
            return {
                ...state,
                error: action.error
            };
        }
        case SUBS_CHANGED: {
            return {
                ...state,
                hasChanged: action.hasChanged
            };
        }
        case SUBS_RESET: {
            return initialState;
        }
        default:
            return state;
    }
}
