import api from '@blocks/api';
import {clearForm} from '@blocks/actions/form';
import {domikIsLoading} from '@blocks/auth/actions';
import {deleteTrackId, TRACK_TYPES} from '@blocks/actions/tracks';
import {getProcessName, isRegisterProcess, isRestoreProcess} from '@blocks/UserEntryFlow/utils';
import {setMetricsHeader} from '@blocks/metrics';

export const CHANGE_STEP = '[USER_ENTRY_FLOW] CHANGE_STEP';
export const CHANGE_PROCESS = '[USER_ENTRY_FLOW] CHANGE_PROCESS';
export const CLEAR_STATE = '[USER_ENTRY_FLOW] CLEAR_STATE';
export const SET_USER_ENTRY_PROCESSED_UID = '[USER_ENTRY_FLOW] SET_USER_ENTRY_PROCESSED_UID';
export const SET_PROCESS_ERROR = '[USER_ENTRY_FLOW] SET_PROCESS_ERROR';
export const CLEAR_PROCESS_ERROR = '[USER_ENTRY_FLOW] CLEAR_PROCESS_ERROR';
export const CAPTCHA_IS_REQUIRED = '[USER_ENTRY_FLOW] CAPTCHA_IS_REQUIRED';
export const SET_FIO_REQUIRED = 'SET_FIO_REQUIRED';
export const SET_IS_REG_AFTER_AUTH_START = 'SET_IS_REG_AFTER_AUTH_START';

export const SET_ALLOWED_REG_FLOW = 'SET_ALLOWED_REG_FLOW';

export const changeStep = (step) => (dispatch) => dispatch({type: CHANGE_STEP, payload: {step}});

export const changeProcess = (process) => (dispatch) => dispatch({type: CHANGE_PROCESS, payload: {process}});

export const clearState = () => (dispatch) => dispatch({type: CLEAR_STATE});

export const setUserEntryProcessedUid = (processedUid) => (dispatch) =>
    dispatch({type: SET_USER_ENTRY_PROCESSED_UID, payload: {processedUid}});

export const restartUserEntryProcess = () => (dispatch) => {
    dispatch(domikIsLoading(true));

    api.userEntryFlowSubmit().then(() => {
        dispatch(clearState());
        dispatch(clearForm());
        dispatch(domikIsLoading(false));
    });
};

export const safeStateClearing = () => (dispatch, getState) => {
    const state = getState();
    const process = getProcessName(state);

    if (!isRestoreProcess(process) && !isRegisterProcess(process)) {
        dispatch(setMetricsHeader());
        dispatch(clearState());
        dispatch(clearForm());
        dispatch(deleteTrackId(TRACK_TYPES.REGISTER));
    }
};

export const setProcessError = (processError) => (dispatch) =>
    dispatch({type: SET_PROCESS_ERROR, payload: {processError}});

export const clearProcessError = () => (dispatch) => dispatch({type: CLEAR_PROCESS_ERROR});

export const captchaIsRequired = (isCaptchaRequired) => (dispatch) =>
    dispatch({type: CAPTCHA_IS_REQUIRED, payload: {isCaptchaRequired}});

export const setFioStepRequired = (payload) => (dispatch) => dispatch({type: SET_FIO_REQUIRED, payload});

export const setAllowedRegFlow = (payload) => (dispatch) => dispatch({type: 'SET_ALLOWED_REG_FLOW', payload});

export const setIsRegAfterAuthStart = (payload) => (dispatch) => dispatch({type: SET_IS_REG_AFTER_AUTH_START, payload});
