import api from '@blocks/api';
import updateFieldStatus from '@blocks/registration/methods/updateFieldStatus';
import findFieldsWithErrors from '@blocks/registration/methods/findFieldsWithErrors';
import checkIfFieldEmpty from '@blocks/registration/methods/checkIfFieldEmpty';
import {errorsTxt} from '@blocks/registration/errors.js';

const getNormalizedFieldName = (fieldName) => (fieldName === 'hint_question' ? 'hint_question_custom' : fieldName);

export const validateSecurityAnswer = (data) => (dispatch, getState) =>
    new Promise((resolve, reject) => {
        const state = getState();
        const track = state.common.track_id || state.tracks.registerTrackId;
        const requestData = Object.assign({}, {track_id: track}, data);

        const fieldNames = Object.keys(data);
        const emptyFieldValidationResult = fieldNames.map((fieldName) => {
            const errors =
                fieldName === 'hint_question' ? errorsTxt.hint.hintQuestionErrors : errorsTxt.hint.hintAnswerErrors;

            return checkIfFieldEmpty(data[fieldName], getNormalizedFieldName(fieldName))(dispatch, {
                code: 'missingvalue',
                text: errors.missingvalue
            });
        });

        if (emptyFieldValidationResult.some(Boolean)) {
            reject();
            return;
        }

        api.request('answer', requestData)
            .then((response) => {
                response.validation_errors &&
                    response.validation_errors.map((error) => {
                        const fieldName = error.field;
                        const errors =
                            fieldName === 'hint_question'
                                ? errorsTxt.hint.hintQuestionErrors
                                : errorsTxt.hint.hintAnswerErrors;
                        const errorObj = {
                            code: error.code,
                            text: errors[error.code]
                        };

                        updateFieldStatus(getNormalizedFieldName(fieldName), 'not_valid')(dispatch, errorObj);
                    });

                fieldNames.forEach((fieldName) => {
                    if (response[fieldName]) {
                        updateFieldStatus(getNormalizedFieldName(fieldName), 'valid')(dispatch, getState);
                        dispatch(findFieldsWithErrors());
                    }
                });

                if (response.validation_errors && response.validation_errors.length) {
                    reject();
                } else {
                    resolve();
                }
            })
            .fail(() => {
                const errorObj = {
                    code: 'global',
                    text: errorsTxt.global && errorsTxt.global.errors && errorsTxt.global.errors.global
                };

                fieldNames.forEach((fieldName) => {
                    updateFieldStatus(getNormalizedFieldName(fieldName), 'not_valid')(dispatch, errorObj);
                });
                reject();
            });
    });
