import {connect} from 'react-redux';
import {getTrackId, getEULATexts, hasExp} from '@blocks/selectors';
import {updateValues} from '@blocks/actions/form';
import {retryToRequestPhoneConfirmationCode} from '@blocks/actions/phoneConfirm';
import switchToModeRegister from '@blocks/authv2/actions/switchToModeRegister';
import {changePagePopupType, changePagePopupVisibility, updateLoginValue} from '@blocks/authv2/actions';
import changeNativeInputValue from '@blocks/authv2/actions/changeNativeInputValue';
import switchToModeAddingAccount from '@blocks/authv2/actions/switchToModeAddingAccount';
import {switchToLogin} from '@blocks/authv2/actions/multiStepAuthStart';
import {TRACK_TYPES} from '@blocks/actions/tracks';
import {setMetricsHeader} from '@blocks/metrics';
import {UserEntryFlow} from './UserEntryFlow.jsx';
import {getProcessName, getSteps} from './utils';
import {onNext, onBack, restartProcess, checkFioStepIsRequired} from './logic';
import {setProcessError, safeStateClearing} from './actions';
import {STEPS} from './steps';
import {sendFingerprint} from '@blocks/actions/sendFingerprint';
import {checkIsNewSuggestByPhone} from '@blocks/UserEntryFlow/utils';

function onNextHandler(nextStep) {
    return (dispatch, getState) => {
        const {am = {}} = getState();

        if (am.isAm && am.mode === 'turbo' && am.phone && nextStep === STEPS.PERSONAL_DATA_AND_PHONE) {
            return dispatch(
                switchToLogin(am.phone, ({isShortCircuit} = {}) => {
                    if (isShortCircuit) {
                        dispatch(onNext(nextStep));
                    }
                })
            );
        }

        dispatch(onNext(nextStep));
    };
}

const mapStateToProps = (state) => {
    const {
        userEntryFlow = {},
        signup = {},
        common = {},
        customs: {isSkipEulaPage = false, hideNeophonishOtherAccountLink = false} = {},
        am: {isAm, mode} = {},
        form = {}
    } = state;
    const {values = {}, humanConfirmation: {isCaptchaRequired} = {}} = form;
    const {eula_accepted: isEulaAccepted, phone} = values;
    const {addUserFullUrl} = common;
    const {step, processError, isFioStepRequired} = userEntryFlow;
    const {mode: signUpMode} = signup;
    const process = getProcessName(state);
    const useNewSuggestByPhone = checkIsNewSuggestByPhone(state);
    const steps = getSteps(process, useNewSuggestByPhone);
    const trackId = getTrackId(state, TRACK_TYPES.REGISTER);
    const canSendFingerprint = hasExp(state, 'passport-authreg-fingerprint-exp') || false;
    const hasChildishExp = hasExp(state, 'profile-family-childish-exp');

    return {
        canSendFingerprint,
        trackId,
        process,
        step: step || steps[0],
        phone,
        processError,
        signUpMode,
        addUserFullUrl,
        isCaptchaRequired,
        useNewSuggestByPhone,
        isFioStepRequired,
        eulaTexts: getEULATexts(state),
        isAmModePhonish: isAm && mode === 'phonish',
        isAm,
        isSkipEulaPage,
        hideNeophonishOtherAccountLink,
        isEulaAccepted,
        hasChildishExp
    };
};

const mapDispatchToProps = {
    sendFingerprint,
    onNext: onNextHandler,
    onBack,
    updateValues,
    retryToRequestPhoneConfirmationCode,
    switchToModeRegister,
    restartProcess,
    setProcessError,
    setMetricsHeader,
    safeStateClearing,
    updateLoginValue,
    changePagePopupVisibility,
    changePagePopupType,
    changeNativeInputValue,
    switchToModeAddingAccount,
    checkFioStepIsRequired
};

const ConnectedUserEntryFlow = connect(mapStateToProps, mapDispatchToProps)(UserEntryFlow);

export {ConnectedUserEntryFlow as UserEntryFlow};

// for loadable
// else use import {UserEntryFlow} from ...
export default ConnectedUserEntryFlow;
