import {
    CHANGE_STEP,
    CHANGE_PROCESS,
    CLEAR_STATE,
    SET_USER_ENTRY_PROCESSED_UID,
    SET_PROCESS_ERROR,
    CLEAR_PROCESS_ERROR,
    CAPTCHA_IS_REQUIRED,
    SET_FIO_REQUIRED,
    SET_ALLOWED_REG_FLOW,
    SET_IS_REG_AFTER_AUTH_START
} from '@blocks/UserEntryFlow/actions';

const initialState = {
    step: '',
    processedUid: '',
    processError: {
        status: 'ok',
        code: '',
        text: '',
        descriptionText: ''
    },
    allowedRegFlow: '',
    isCaptchaRequired: false,
    isFioStepRequired: true,
    isRegAfterAuthStart: false
};

export const userEntryFlow = (state = initialState, action = {}) => {
    const {type, payload = {}} = action;

    switch (type) {
        case CHANGE_STEP: {
            const {step} = payload;

            return Object.assign({}, state, {step});
        }

        case CHANGE_PROCESS: {
            const {process} = payload;

            return Object.assign({}, state, {process});
        }

        case SET_PROCESS_ERROR: {
            const {processError} = payload;

            return Object.assign({}, state, {processError});
        }

        case SET_USER_ENTRY_PROCESSED_UID: {
            const {processedUid} = payload;

            return Object.assign({}, state, {processedUid});
        }

        case CLEAR_STATE: {
            return initialState;
        }

        case CLEAR_PROCESS_ERROR: {
            return Object.assign({}, state, {processError: initialState.processError});
        }

        case CAPTCHA_IS_REQUIRED: {
            const {isCaptchaRequired} = payload;

            return Object.assign({}, state, {isCaptchaRequired});
        }

        case SET_FIO_REQUIRED: {
            return Object.assign({}, state, {isFioStepRequired: payload});
        }

        case SET_ALLOWED_REG_FLOW: {
            return Object.assign({}, state, {allowedRegFlow: payload});
        }

        case SET_IS_REG_AFTER_AUTH_START: {
            return Object.assign({}, state, {isRegAfterAuthStart: payload});
        }

        default: {
            return state;
        }
    }
};
