import {FIELDS_NAMES} from '@components/Field/names';

export const STEPS = {
    CAPTCHA: 'captcha',
    CURRENT_PASSWORD: 'currentPassword',
    PHONE: 'phone',
    PHONE_CONFIRM: 'phoneConfirm',
    PERSONAL_DATA: 'personalData',
    ACCOUNTS: 'accounts',
    LOGIN: 'login',
    PASSWORD: 'password',
    EULA: 'eula',
    PERSONAL_DATA_AND_PHONE: 'personalDataAndPhone',
    SQ_SA: 'securityQuestionSecurityAnswer'
};

export const REGISTER_STEPS = [
    STEPS.PHONE,
    STEPS.PHONE_CONFIRM,
    STEPS.PERSONAL_DATA,
    STEPS.ACCOUNTS,
    STEPS.LOGIN,
    STEPS.PASSWORD,
    STEPS.EULA
];

export const REGISTER_PORTAL_STEPS = [
    STEPS.PHONE,
    STEPS.PHONE_CONFIRM,
    STEPS.ACCOUNTS,
    STEPS.PERSONAL_DATA,
    STEPS.LOGIN,
    STEPS.PASSWORD,
    STEPS.EULA
];

export const REGISTER_NO_PHONE_STEPS = [
    STEPS.PHONE,
    STEPS.SQ_SA,
    STEPS.PERSONAL_DATA,
    STEPS.ACCOUNTS,
    STEPS.LOGIN,
    STEPS.PASSWORD,
    STEPS.EULA
];

export const REGISTER_NEOPHONISH_STEPS = [
    STEPS.PHONE,
    STEPS.PHONE_CONFIRM,
    STEPS.PERSONAL_DATA,
    STEPS.ACCOUNTS,
    STEPS.EULA
];

export const REGISTER_NEOPHONISH_STEPS_WITHOUT_PERSONAL_DATA = [
    STEPS.PHONE,
    STEPS.PHONE_CONFIRM,
    STEPS.ACCOUNTS,
    STEPS.EULA
];

export const REGISTER_WITH_FULL_PERSONAL_INFO_STEPS = [
    STEPS.PERSONAL_DATA_AND_PHONE,
    STEPS.PHONE_CONFIRM,
    STEPS.ACCOUNTS,
    STEPS.LOGIN,
    STEPS.PASSWORD,
    STEPS.EULA
];

export const REGISTER_NEOPHONISH_WITH_FULL_PERSONAL_INFO_STEPS = [
    STEPS.PERSONAL_DATA_AND_PHONE,
    STEPS.PHONE_CONFIRM,
    STEPS.ACCOUNTS,
    STEPS.EULA
];

export const COMMON_STEPS = [STEPS.PHONE, STEPS.PHONE_CONFIRM, STEPS.PERSONAL_DATA, STEPS.ACCOUNTS];
export const COMMON_STEPS_WITHOUT_PERSONAL_DATA = [STEPS.PHONE, STEPS.PHONE_CONFIRM, STEPS.ACCOUNTS];

export const getFields = (step, state) => {
    const {
        form: {
            values: {hint_question_id}
        }
    } = state;
    const fields = {
        [STEPS.PERSONAL_DATA]: [FIELDS_NAMES.FIRSTNAME, FIELDS_NAMES.LASTNAME],
        [STEPS.PERSONAL_DATA_AND_PHONE]: [FIELDS_NAMES.FIRSTNAME, FIELDS_NAMES.LASTNAME, FIELDS_NAMES.PHONE],
        [STEPS.PHONE]: [FIELDS_NAMES.PHONE],
        [STEPS.LOGIN]: [FIELDS_NAMES.LOGIN],
        [STEPS.PASSWORD]: [FIELDS_NAMES.PASSWORD],
        [STEPS.SQ_SA]:
            hint_question_id === '99'
                ? [FIELDS_NAMES.HINT_QUESTION_CUSTOM, FIELDS_NAMES.HINT_ANSWER]
                : [FIELDS_NAMES.HINT_ANSWER]
    };

    return fields[step] || [];
};
