import {removeTrailingSlash} from '@blocks/utils';
import {hasExp, isNeoPhonishRegisterAvailable} from '@blocks/selectors';
import {MODE_BROWSER} from '@blocks/SignUp/modes/constants';
import {
    COMMON_STEPS,
    COMMON_STEPS_WITHOUT_PERSONAL_DATA,
    REGISTER_NEOPHONISH_STEPS,
    REGISTER_NEOPHONISH_STEPS_WITHOUT_PERSONAL_DATA,
    REGISTER_STEPS,
    REGISTER_NO_PHONE_STEPS,
    REGISTER_WITH_FULL_PERSONAL_INFO_STEPS,
    REGISTER_NEOPHONISH_WITH_FULL_PERSONAL_INFO_STEPS,
    REGISTER_PORTAL_STEPS
} from './steps';
import {
    ENTRY_REGISTER_BROWSER_PROCESS,
    ENTRY_REGISTER_NEOPHONISH_PROCESS,
    ENTRY_REGISTER_PROCESS,
    ENTRY_REGISTER_PORTAL_PROCESS,
    ENTRY_REGISTER_NO_PHONE_PROCESS,
    ENTRY_RESTORE_PROCESS,
    ENTRY_RESTORE_NEOPHONISH_PROCESS,
    ENTRY_REGISTER_ROUTE,
    ENTRY_RESTORE_ROUTE,
    ENTRY_RESTORE_NEOPHONISH_ROUTE,
    ENTRY_REGISTER_WITH_FULL_PERSONAL_INFO_PROCESS,
    ENTRY_REGISTER_WITH_FULL_PERSONAL_INFO_NEOPHONISH_PROCESS
} from './processes';
import {RegType} from '@blocks/authv2/nativeMobileApi/constants';

export const getProcessName = (state = {}) => {
    const {router = {}, common = {}, signup = {}, am = {}, userEntryFlow: {process} = {}} = state;
    const {location = {}} = router;
    const {mode: signupMode, config = {}} = signup;
    const {registerWithFullPersonalInfoOrigins = []} = config;
    const {pane, origin = ''} = common;
    const {pathname} = location;
    const path = removeTrailingSlash(pathname === '/' ? pane : pathname);
    const isNeoPhonishRegister = isNeoPhonishRegisterAvailable(state);

    // TODO можно сделать лучше, но на регистрации в Ябро нужен роутер
    if (signupMode === MODE_BROWSER) {
        return ENTRY_REGISTER_BROWSER_PROCESS;
    }

    if (process === ENTRY_REGISTER_NEOPHONISH_PROCESS) {
        return ENTRY_REGISTER_NEOPHONISH_PROCESS;
    }

    if (process === ENTRY_REGISTER_PORTAL_PROCESS) {
        return ENTRY_REGISTER_PORTAL_PROCESS;
    }

    // we can't enter to that process by 'path'
    if (process === ENTRY_REGISTER_NO_PHONE_PROCESS) {
        return ENTRY_REGISTER_NO_PHONE_PROCESS;
    }

    switch (path) {
        case ENTRY_REGISTER_ROUTE: {
            return registerWithFullPersonalInfoOrigins.includes(origin) || (am.isAm && am.mode === 'turbo')
                ? isNeoPhonishRegister
                    ? ENTRY_REGISTER_WITH_FULL_PERSONAL_INFO_NEOPHONISH_PROCESS
                    : ENTRY_REGISTER_WITH_FULL_PERSONAL_INFO_PROCESS
                : isNeoPhonishRegister
                ? ENTRY_REGISTER_NEOPHONISH_PROCESS
                : ENTRY_REGISTER_PROCESS;
        }

        case ENTRY_RESTORE_ROUTE: {
            return ENTRY_RESTORE_PROCESS;
        }

        case ENTRY_RESTORE_NEOPHONISH_ROUTE: {
            return ENTRY_RESTORE_NEOPHONISH_PROCESS;
        }

        default: {
            return undefined;
        }
    }
};

export const getNextStep = (step, process, useNewSuggestByPhone, allowedRegFlow) => {
    const steps = getSteps(process, useNewSuggestByPhone, allowedRegFlow);

    return steps[steps.indexOf(step) + 1];
};

export const getPrevStep = (step, process, useNewSuggestByPhone) => {
    const steps = getSteps(process, useNewSuggestByPhone);

    return steps[steps.indexOf(step) - 1];
};

export const getSteps = (process, useNewSuggestByPhone, allowedRegFlow) => {
    const isPortalRegAllowed = allowedRegFlow === 'portal';

    switch (process) {
        case ENTRY_REGISTER_PROCESS: {
            return useNewSuggestByPhone && !isPortalRegAllowed ? COMMON_STEPS_WITHOUT_PERSONAL_DATA : REGISTER_STEPS;
        }

        case ENTRY_REGISTER_PORTAL_PROCESS: {
            return REGISTER_PORTAL_STEPS;
        }

        case ENTRY_REGISTER_NO_PHONE_PROCESS: {
            return REGISTER_NO_PHONE_STEPS;
        }

        case ENTRY_REGISTER_NEOPHONISH_PROCESS: {
            if (useNewSuggestByPhone && isPortalRegAllowed) {
                return REGISTER_PORTAL_STEPS;
            }

            return useNewSuggestByPhone ? REGISTER_NEOPHONISH_STEPS_WITHOUT_PERSONAL_DATA : REGISTER_NEOPHONISH_STEPS;
        }

        case ENTRY_REGISTER_WITH_FULL_PERSONAL_INFO_PROCESS: {
            return REGISTER_WITH_FULL_PERSONAL_INFO_STEPS;
        }

        case ENTRY_REGISTER_WITH_FULL_PERSONAL_INFO_NEOPHONISH_PROCESS: {
            return REGISTER_NEOPHONISH_WITH_FULL_PERSONAL_INFO_STEPS;
        }

        case ENTRY_RESTORE_NEOPHONISH_PROCESS: {
            return useNewSuggestByPhone ? COMMON_STEPS_WITHOUT_PERSONAL_DATA : COMMON_STEPS;
        }

        case ENTRY_RESTORE_PROCESS: {
            return useNewSuggestByPhone ? COMMON_STEPS_WITHOUT_PERSONAL_DATA : COMMON_STEPS;
        }

        default: {
            return COMMON_STEPS;
        }
    }
};

export const isValidStep = (process, step) => {
    return getSteps(process).includes(step);
};

export const isRegisterProcess = (process = '') =>
    [
        ENTRY_REGISTER_NEOPHONISH_PROCESS,
        ENTRY_REGISTER_PROCESS,
        ENTRY_REGISTER_PORTAL_PROCESS,
        ENTRY_REGISTER_NO_PHONE_PROCESS,
        ENTRY_REGISTER_BROWSER_PROCESS,
        ENTRY_REGISTER_WITH_FULL_PERSONAL_INFO_NEOPHONISH_PROCESS,
        ENTRY_REGISTER_WITH_FULL_PERSONAL_INFO_PROCESS
    ].includes(process);

export const isRegisterNeophonishProcess = (process = '') =>
    [ENTRY_REGISTER_NEOPHONISH_PROCESS, ENTRY_REGISTER_WITH_FULL_PERSONAL_INFO_NEOPHONISH_PROCESS].includes(process);

export const isRestoreProcess = (process = '') =>
    [ENTRY_RESTORE_PROCESS, ENTRY_RESTORE_NEOPHONISH_PROCESS].includes(process);

export const isUserEntryFlowProcess = (process) => isRestoreProcess(process) || isRegisterProcess(process);
export const isUserEntryFlowProcessSecondaryStep = (process, step) =>
    isUserEntryFlowProcess(process) && step && step !== getSteps(process)[0];

export const checkIsNewSuggestByPhone = (state) => {
    const {am: {regType} = {}} = state;

    return hasExp(state, 'use-new-suggest-by-phone') || regType === RegType.DOREGISH;
};

export const checkIsDoregishFlowProcess = (state) => {
    const {userEntryFlow: {isFioStepRequired} = {}} = state;
    const useNewSuggestByPhone = checkIsNewSuggestByPhone(state);

    return useNewSuggestByPhone && !isFioStepRequired;
};
