import React, {useEffect} from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Header} from '@blocks/authv2/components/Layout/Header';
import {PagePopup} from '@blocks/authv2/components/PagePopup';
import Challenge from '@blocks/authv2/pages/Challenge/Challenge';
import PageOverlay from '@blocks/authv2/components/PageOverlay/PageOverlay.jsx';

import './UserValidate.styl';

const b = cn('UserValidate');

export const UserValidate = ({
    isShowPagePopup,
    isOneStepChallenge,
    confirmPhone,
    is3dsChallenge,
    isOneStep3dsExp,
    isTrustFrameOpened
}) => {
    useEffect(() => {
        if (isOneStepChallenge) {
            confirmPhone();
        }
    });

    const isBigWidth = is3dsChallenge && isOneStep3dsExp && isTrustFrameOpened;
    const isTouchWidthFull = is3dsChallenge && !isTrustFrameOpened;

    return (
        <div className={b('wrap', {isTouchWidthFull})}>
            <div className={b('block', {isBigWidth, isTouchWidthFull}, ['passp-auth'])} data-t='challenge'>
                {isShowPagePopup ? (
                    <PagePopup />
                ) : (
                    <>
                        <Header />
                        <Challenge />
                    </>
                )}
            </div>
            <PageOverlay />
        </div>
    );
};

UserValidate.propTypes = {
    isShowPagePopup: PropTypes.bool.isRequired,
    isOneStepChallenge: PropTypes.bool.isRequired,
    confirmPhone: PropTypes.func.isRequired,
    is3dsChallenge: PropTypes.bool,
    isOneStep3dsExp: PropTypes.bool,
    isTrustFrameOpened: PropTypes.bool
};
