import api from '../../api';
import {set3dsLoadingStatus} from './';
import {redirect} from '@blocks/authv2/actions';
import {setChallengeError} from '@blocks/authv2/actions/challenge/';
import metrics from '@blocks/metrics';
import passport from '@plibs/pclientjs';
import {CHALLENGES_PAGE, CHALLENGES_PAGE_3DS_GO_TO_RETPATH_SUCCESS} from '@blocks/authv2/metrics_constants';

export const commit3ds = () => {
    return (dispatch, getState) => {
        dispatch(set3dsLoadingStatus(true));
        const {state: {challenge: {url3ds = ''} = {}} = {}} = getState();
        const url3dsQuery = (passport.util && passport.util.getUrlParamsV2(url3ds)) || {};
        const {purchase_token: purchaseToken = ''} = url3dsQuery;

        api.request('user-validate/commit3ds', {purchaseToken})
            .done((response = {}) => {
                const {status} = response;

                if (status === 'ok') {
                    api.request('user-validate/3ds-retpath').done((response = {}) => {
                        const {retpath} = response;

                        metrics.send([CHALLENGES_PAGE, CHALLENGES_PAGE_3DS_GO_TO_RETPATH_SUCCESS]);

                        redirect(retpath);
                    });
                }
            })
            .fail((error) => {
                const errorCode = Array.isArray(error.errors) && error.errors[0];

                if (['3ds.not_enough_funds', '3ds.failed'].includes(errorCode)) {
                    dispatch(
                        setChallengeError({
                            code: errorCode,
                            text: i18n('_AUTH_.challenge.3ds-error.3ds-failed')
                        })
                    );
                    dispatch(set3dsLoadingStatus(false));
                    return;
                }

                dispatch(
                    setChallengeError({
                        code: 'internal3ds',
                        text: i18n('_AUTH_.challenge.3ds-error.internal')
                    })
                );
                dispatch(set3dsLoadingStatus(false));
            });
    };
};
