import api from '../../api';
import {set3dsLoadingStatus} from './';
import {redirect} from '@blocks/authv2/actions';
import metrics from '@blocks/metrics';
import {CHALLENGES_PAGE, CHALLENGES_PAGE_3DS_GO_TO_RETPATH_ERROR} from '@blocks/authv2/metrics_constants';

export const redirectToErrorFrom3ds = () => {
    return (dispatch) => {
        dispatch(set3dsLoadingStatus(true));

        api.request('user-validate/3ds-retpath', {isErrorRetpath: true}).done((response = {}) => {
            const {retpath} = response;

            metrics.send([CHALLENGES_PAGE, CHALLENGES_PAGE_3DS_GO_TO_RETPATH_ERROR]);

            redirect(retpath);
        });
    };
};
