import api from '../../api';
import {setChallenge3dsUrl, set3dsLoadingStatus} from './';
import {redirect} from '@blocks/authv2/actions';
import {setChallengeError} from '@blocks/authv2/actions/challenge/';

export const submit3ds = () => {
    return (dispatch, getState) => {
        const {settings: {isTouch} = {}} = getState();

        dispatch(set3dsLoadingStatus(true));

        api.request('user-validate/submit3ds', {useMobileLayout: isTouch})
            .done((response = {}) => {
                const {status, url3ds} = response;

                if (status === 'ok') {
                    if (url3ds) {
                        dispatch(setChallenge3dsUrl(url3ds));
                        return;
                    }

                    api.request('user-validate/3ds-retpath').done((response = {}) => {
                        const {retpath} = response;

                        dispatch(set3dsLoadingStatus(false));
                        redirect(retpath);
                    });
                }
            })
            .fail(() => {
                dispatch(
                    setChallengeError({
                        code: 'internal3ds',
                        text: i18n('_AUTH_.challenge.3ds-error.internal')
                    })
                );
                dispatch(set3dsLoadingStatus(false));
            });
    };
};
