import api from '../../api';
import {setChallengeError} from '@blocks/authv2/actions/challenge/index';
import {changeLoadingStatus} from '@blocks/actions/spin';
import handleError from '@blocks/authv2/actions/challenge/handleError';

export default function userValidateCommit() {
    return (dispatch, getState) => {
        const {
            common: {track_id: trackId, csrf},
            challenge: {challengeType, fieldValue}
        } = getState();
        const params = {
            track_id: trackId,
            csrf_token: csrf,
            challenge: challengeType
        };

        if (challengeType !== 'phone_confirmation') {
            params.answer = fieldValue;

            if (!fieldValue.trim()) {
                dispatch(handleError('missingvalue'));
                return;
            }
        }

        dispatch(changeLoadingStatus(true));

        api.request('user-validate/commit', params)
            .done((response = {}) => {
                const {status, retpath} = response;

                if (status === 'ok' && retpath) {
                    location.href = retpath;
                    return;
                }

                dispatch(changeLoadingStatus(false));
                dispatch(
                    setChallengeError({
                        code: 'internal',
                        text: i18n('_AUTH_.avatar.error-internal')
                    })
                );
            })
            .fail((error) => {
                const errorCode = Array.isArray(error.error) && error.error[0];

                dispatch(handleError(errorCode));
                dispatch(changeLoadingStatus(false));
            });
    };
}
