import {connect} from 'react-redux';
import {UserValidate} from './UserValidate.jsx';
import confirmPhone from '@blocks/authv2/actions/challenge/confirmPhone';

const mapStateToProps = (state = {}) => {
    const {pagePopup: {isShowPagePopup} = {}, challenge = {}} = state;
    const {challengeType, isOneStep3dsExp, isTrustFrameOpened = false, isOneStepChallenge} = challenge;

    return {
        isShowPagePopup,
        is3dsChallenge: challengeType === '3ds',
        isOneStep3dsExp,
        isTrustFrameOpened,
        isOneStepChallenge
    };
};

const mapDispatchToProps = {
    confirmPhone
};

const ConnectedUserValidate = connect(mapStateToProps, mapDispatchToProps)(UserValidate);

export {ConnectedUserValidate as UserValidate};
