import React from 'react';
import {useSelector} from 'react-redux';
import {Title} from '@components/Title';
import {Description} from '@components/Description';
import {VerificationExample} from './components/VerificationExample';
import {VerificationAttention} from './components/VerificationAttention';
import {VerificationForm} from './components/VerificationForm';
import {cn} from '@bem-react/classname';

import './Verification.styl';

const b = cn('Verification');

export const Verification = () => {
    const isNewLayout = useSelector((state) => state.settings.isNewLayout);
    const {isPplMode, links} = useSelector((state) => state.verification);

    return (
        <div className={b({nl: isNewLayout})}>
            <div className={b('head')}>
                <Title size='xxl'>
                    {isPplMode ? i18n('Verification.head.title.ppl') : i18n('Verification.head.title')}
                </Title>
                <Description>
                    {isPplMode ? (
                        <>
                            <div
                                dangerouslySetInnerHTML={{
                                    __html: i18n('Verification.head.explanation.ppl').replace(
                                        '%1',
                                        `<a href=${links.landingPpl} class='${b('link')}'>${i18n(
                                            'Verification.head.explanation.ppl.landing'
                                        )}</a>`
                                    )
                                }}
                            />
                        </>
                    ) : (
                        i18n('Verification.head.explanation.v2')
                    )}
                </Description>
            </div>
            {!isPplMode && (
                <>
                    <div className={b('example')}>
                        <VerificationExample />
                    </div>
                    <div className={b('attention')}>
                        <VerificationAttention />
                    </div>
                </>
            )}
            <div className={b('form')}>
                <VerificationForm />
            </div>
        </div>
    );
};
