import React from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';

export const VerificationChangeButton = ({href, currentPage, dataT = ''}) => (
    <Button
        size='m'
        as='a'
        dataT={`verification:change:${dataT}`}
        href={`${href}?retpath=${currentPage}`}
        view='default'
        width='max'
    >
        {i18n('_AUTH_.change')}
    </Button>
);

VerificationChangeButton.propTypes = {
    href: PropTypes.string,
    currentPage: PropTypes.string,
    dataT: PropTypes.string
};
