import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';
import {getError} from '@blocks/utils';
import {VerificationEmailModal} from '../../modals/VerificationEmailModal';
import {VerificationChangeButton} from '../VerificationChangeButton';

export class VerificationEmailButton extends Component {
    state = {isModalOpened: false};
    onButtonClick = () => {
        const {postCreateEmail, email: {isConfirmInProgress} = {}} = this.props;

        return isConfirmInProgress ? this.openModal() : postCreateEmail(this.openModal, this.onCreateFail);
    };
    onCreateFail = ({errors}) => {
        const {setError} = this.props;
        const {text, code} = getError('email', errors[0]);

        setError({code, text, source: 'email_button'});
    };
    openModal = () => this.setState({isModalOpened: true});
    closeModal = () => this.setState({isModalOpened: false});
    render() {
        const {email: {isConfirmed, value} = {}, text} = this.props;
        const {isModalOpened} = this.state;

        return (
            <>
                {isConfirmed ? (
                    <VerificationChangeButton href='/profile/emails' dataT='email' />
                ) : (
                    <Button
                        size='m'
                        view='default'
                        width='max'
                        onClick={this.onButtonClick}
                        disabled={!value}
                        dataT='verification:email'
                    >
                        {text}
                    </Button>
                )}
                <VerificationEmailModal visible={isModalOpened} closeModal={this.closeModal} />
            </>
        );
    }
}

VerificationEmailButton.propTypes = {
    text: PropTypes.string,
    email: PropTypes.shape({
        value: PropTypes.string,
        isConfirmed: PropTypes.bool
    }),
    postCreateEmail: PropTypes.func,
    setError: PropTypes.func
};
