import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';
import {getError} from '@blocks/utils';
import {VerificationPhoneModal} from '../../modals/VerificationPhoneModal';
import {VerificationChangeButton} from '../VerificationChangeButton';

export class VerificationPhoneButton extends Component {
    state = {isModalOpened: false};
    onButtonClick = () => {
        const {postCreatePhone, phone: {isConfirmInProgress} = {}} = this.props;

        if (isConfirmInProgress) {
            return this.openModal();
        }
        return postCreatePhone(this.openModal, this.onFail);
    };
    onFail = ({errors}) => {
        const {setError} = this.props;
        const {text, code} = getError('phone', errors[0]);

        setError({code, text, source: 'phone_button'});
    };
    openModal = () => this.setState({isModalOpened: true});
    closeModal = () => this.setState({isModalOpened: false});
    render() {
        const {phone: {value, isConfirmed} = {}, text} = this.props;
        const {isModalOpened} = this.state;

        return (
            <>
                {isConfirmed ? (
                    <VerificationChangeButton href='/profile/phones' dataT='phone' />
                ) : (
                    <Button
                        size='m'
                        view='default'
                        width='max'
                        onClick={this.onButtonClick}
                        disabled={!value}
                        dataT='verification:phone'
                    >
                        {text}
                    </Button>
                )}
                <VerificationPhoneModal visible={isModalOpened} closeModal={this.closeModal} />
            </>
        );
    }
}

VerificationPhoneButton.propTypes = {
    text: PropTypes.string,
    phone: PropTypes.shape({
        value: PropTypes.string,
        isConfirmed: PropTypes.bool,
        isConfirmInProgress: PropTypes.bool
    }),
    phoneChangeUrl: PropTypes.string,
    postCreatePhone: PropTypes.func,
    setError: PropTypes.func
};
