import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Attach} from '@components/Attach';
import {VerificationPhoto} from '../../components/VerificationPhoto';
import {cn} from '@bem-react/classname';

import './VerificationPhotoButton.styl';

const b = cn('VerificationPhotoButton');

export class VerificationPhotoButton extends Component {
    onChange = ({target} = {}) => {
        const {postPhoto} = this.props;

        if (target) {
            this.removeError();
            postPhoto(target.files);
        }
    };
    removeError = (isForced) => {
        const {error, setError} = this.props;

        if (error && (error.source === 'photo' || isForced)) {
            setError(null);
        }
    };
    setAttach = (attach) => (this.attach = attach);
    onClose = () => {
        this.attach.querySelector('input').value = '';
        this.removeError(true);
    };
    render() {
        const {photoSrc} = this.props;

        return (
            <div className={b()}>
                <div className={b('input', {hide: Boolean(photoSrc)})}>
                    <Attach
                        size='m'
                        width='max'
                        view='default'
                        onChange={this.onChange}
                        name='attach_file'
                        id='VerificationAttach'
                        accept='image'
                        dataT='verification:photo-button'
                        innerRef={this.setAttach}
                    >
                        {i18n('Verification.photo-button.text')}
                    </Attach>
                </div>
                <div className={b('photo', {hide: !photoSrc})}>
                    <VerificationPhoto onClose={this.onClose} />
                </div>
            </div>
        );
    }
}

VerificationPhotoButton.propTypes = {
    photoSrc: PropTypes.string,
    error: PropTypes.object,
    postPhoto: PropTypes.func.isRequired,
    setError: PropTypes.func.isRequired
};
