import {connect} from 'react-redux';
import {postPhoto, setError} from '../../api';
import {VerificationPhotoButton as Button} from './VerificationPhotoButton';

const mapStateToProps = ({verification}) => {
    const {photoSrc, error} = verification || {};

    return {photoSrc, error};
};

const mapDispatchToProps = {postPhoto, setError};

export const VerificationPhotoButton = connect(mapStateToProps, mapDispatchToProps)(Button);
