import React from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';
import {VerificationSendModal} from '../../modals/VerificationSendModal';

export class VerificationSendButton extends React.Component {
    state = {isModalOpened: false, errors: []};
    onButtonClick = () => {
        const {postForm, postFormPpl, isPplMode} = this.props;

        this.setState({errors: []});

        if (isPplMode) {
            return postFormPpl()
                .fail(this.onFail)
                .done(this.openModal);
        }

        return postForm()
            .fail(this.onFail)
            .done(this.openModal);
    };
    onFail = ({errors = []} = {}) => this.setState({isModalOpened: true, errors});
    openModal = () => this.setState({isModalOpened: true});
    closeModal = () => this.setState({isModalOpened: false});
    render() {
        const {isDisabled} = this.props;
        const {isModalOpened, errors} = this.state;

        return (
            <>
                <Button
                    view='action'
                    width='max'
                    onClick={this.onButtonClick}
                    disabled={isDisabled}
                    size='m'
                    dataT='verification:send'
                >
                    {i18n('Frontend.send')}
                </Button>
                <VerificationSendModal visible={isModalOpened} closeModal={this.closeModal} errors={errors} />
            </>
        );
    }
}

VerificationSendButton.propTypes = {
    postForm: PropTypes.func,
    postFormPpl: PropTypes.func,
    isPplMode: PropTypes.bool,
    isDisabled: PropTypes.bool
};
