import {connect} from 'react-redux';
import {VerificationSendButton as Button} from './VerificationSendButton';
import {postForm, postFormPpl} from '../../api';

const mapStateToProps = ({verification}) => {
    const {isPplMode, checkboxes, phone, email, socials, reason, photoSrc} = verification || {};
    const {isAcceptTerms, isAcceptVerification} = checkboxes || {};
    const isPhoneConfirmed = Boolean((phone || {}).isConfirmed);
    const isEmailConfirmed = Boolean((email || {}).isConfirmed);
    const isDisabled = isPplMode
        ? !(isAcceptTerms && isEmailConfirmed && photoSrc)
        : !(
              isAcceptTerms &&
              isAcceptVerification &&
              photoSrc &&
              isPhoneConfirmed &&
              isEmailConfirmed &&
              reason &&
              socials.some(Boolean)
          );

    return {
        isPplMode,
        isDisabled
    };
};

const mapDispatchToProps = {postForm, postFormPpl};

export const VerificationSendButton = connect(mapStateToProps, mapDispatchToProps)(Button);
