import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';

const SOCIALS_MAX_COUNT = 7;

export class VerificationSocialsButton extends Component {
    onClick = () => {
        const {addSocial} = this.props;

        addSocial();
    };
    render() {
        const {socials} = this.props;

        if (socials && socials.length >= SOCIALS_MAX_COUNT) {
            return null;
        }

        return (
            <Button size='m' width='max' view='default' onClick={this.onClick} dataT='verification:socials'>
                {i18n('Verification.socials-button.text')}
            </Button>
        );
    }
}

VerificationSocialsButton.propTypes = {
    socials: PropTypes.arrayOf(PropTypes.string),
    addSocial: PropTypes.func
};
