import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Checkbox} from '@components/Checkbox';
import {cn} from '@bem-react/classname';

import './VerificationCheckbox.styl';

const b = cn('VerificationCheckbox');

export class VerificationCheckbox extends Component {
    onChange = () => {
        const {onChange, checked} = this.props;

        onChange(!checked);
    };
    render() {
        const {label, description, id, checked, dataT} = this.props;

        return (
            <div className={b()} data-t={`verification:checkbox:${dataT}:wrap`}>
                <div className={b('checkbox')}>
                    <Checkbox
                        id={id}
                        checked={checked}
                        onChange={this.onChange}
                        data-t={`verification:checkbox:${dataT}`}
                    />
                </div>
                <div className={b('text')}>
                    <label htmlFor={id} className={b('label')} dangerouslySetInnerHTML={{__html: label}} />
                    {Boolean(description) && <div className={b('description')}>{description}</div>}
                </div>
            </div>
        );
    }
}

VerificationCheckbox.propTypes = {
    label: PropTypes.node.isRequired,
    dataT: PropTypes.string,
    checked: PropTypes.bool,
    description: PropTypes.string,
    id: PropTypes.string.isRequired,
    onChange: PropTypes.func.isRequired
};
