import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {VerificationCheckbox} from '../VerificationCheckbox';
import {cn} from '@bem-react/classname';

import './VerificationCheckboxes.styl';

const b = cn('VerificationCheckboxes');

export class VerificationCheckboxes extends Component {
    onAcceptTermsChange = (value) => {
        const {setAcceptTerms} = this.props;

        setAcceptTerms(value);
    };
    onAcceptVerificationChange = (value) => {
        const {setAcceptVerification} = this.props;

        setAcceptVerification(value);
    };
    onAcceptDeleteChange = (value) => {
        const {setAcceptDelete} = this.props;

        setAcceptDelete(value);
    };
    render() {
        const {isPplMode, login, publicName, isAcceptTerms, isAcceptVerification, isAcceptDelete, links} = this.props;

        return (
            <div className={b()} data-t='verification:checkboxes'>
                {isPplMode && (
                    <VerificationCheckbox
                        label={i18n('Verification.form.checkbox.delete')}
                        id='Verification-form-checkbox-delete'
                        onChange={this.onAcceptDeleteChange}
                        checked={isAcceptDelete}
                        dataT='delete'
                    />
                )}
                {!isPplMode && (
                    <VerificationCheckbox
                        label={i18n('Verification.form.checkbox.accept')
                            .replace('%1', `<b>${login}</b>`)
                            .replace('%2', `<b>${publicName}</b>`)}
                        id='Verification-form-checkbox-accept'
                        description={i18n('Verification.form.checkbox.accept.description.v2')}
                        onChange={this.onAcceptVerificationChange}
                        checked={isAcceptVerification}
                        dataT='accept'
                    />
                )}
                <VerificationCheckbox
                    label={
                        isPplMode
                            ? i18n('Verification.form.checkbox.terms.ppl').replace(
                                  '%1',
                                  `<a href=${links.confidential} class='${b('link')}'>${i18n(
                                      'Verification.form.checkbox.terms.confidential.ppl'
                                  )}</a>`
                              )
                            : i18n('Verification.form.checkbox.terms')
                                  .replace(
                                      '%1',
                                      `<a href=${links.rules} class='${b('link')}'>${i18n(
                                          'Verification.form.checkbox.terms.rules'
                                      )}</a>`
                                  )
                                  .replace(
                                      '%2',
                                      `<a href=${links.confidential} class='${b('link')}'>${i18n(
                                          'Verification.form.checkbox.terms.confidential'
                                      )}</a>`
                                  )
                    }
                    id='Verification-form-checkbox-terms'
                    onChange={this.onAcceptTermsChange}
                    checked={isAcceptTerms}
                    dataT='terms'
                />
            </div>
        );
    }
}

VerificationCheckboxes.propTypes = {
    isPplMode: PropTypes.bool,
    login: PropTypes.string,
    publicName: PropTypes.string,
    setAcceptVerification: PropTypes.func,
    setAcceptTerms: PropTypes.func,
    setAcceptDelete: PropTypes.func,
    isAcceptTerms: PropTypes.bool,
    isAcceptVerification: PropTypes.bool,
    isAcceptDelete: PropTypes.bool,
    links: PropTypes.shape({
        rules: PropTypes.string,
        confidential: PropTypes.string
    })
};
