import {connect} from 'react-redux';
import {VerificationCheckboxes as Checkboxes} from './VerificationCheckboxes';
import {setAcceptVerification, setAcceptTerms, setAcceptDelete} from '../../api';

const mapStateToProps = ({verification}) => {
    const {isPplMode, user, checkboxes, links} = verification || {};
    const {login, publicName} = user || {};
    const {isAcceptTerms, isAcceptVerification, isAcceptDelete} = checkboxes;

    return {isPplMode, login, publicName, isAcceptTerms, isAcceptVerification, isAcceptDelete, links};
};

const mapDispatchToProps = {
    setAcceptVerification,
    setAcceptTerms,
    setAcceptDelete
};

export const VerificationCheckboxes = connect(mapStateToProps, mapDispatchToProps)(Checkboxes);
