import React from 'react';
import {cn} from '@bem-react/classname';

import './VerificationExample.styl';

const b = cn('VerificationExample');

const VerifiedMark = () => (
    <svg fill='none' height='24' viewBox='0 0 24 24' width='24' xmlns='http://www.w3.org/2000/svg'>
        <path
            clipRule='evenodd'
            // eslint-disable-next-line max-len
            d='m8.26883 22.8431c-1.6147.2135-3.17128-.6849-3.79416-2.1898l-.32998-.798-.79795-.33c-1.50407-.6238-2.402054-2.1797-2.18987-3.7941l.1128-.8556-.525572-.6851c-.992131-1.2918-.992131-3.0892 0-4.38096l.525572-.68516-.1128-.85555c-.213479-1.6147.68493-3.17128 2.18987-3.79416l.79795-.32998.32998-.79795c.62387-1.50407 2.17972-2.402054 3.79416-2.18987l.85555.1128.68516-.525572c1.29176-.992131 3.08916-.992131 4.38096 0l.6851.525572.8556-.1128c1.6147-.213479 3.1712.68493 3.7941 2.18987l.33.79795.798.32998c1.504.62387 2.402 2.17972 2.1898 3.79416l-.1128.85555.5256.68516c.9921 1.29176.9921 3.08916 0 4.38096l-.5256.6851.1128.8556c.2135 1.6147-.6849 3.1712-2.1898 3.7941l-.798.33-.33.798c-.6238 1.504-2.1797 2.402-3.7941 2.1898l-.8556-.1128-.6851.5256c-1.2918.9921-3.0892.9921-4.38096 0l-.68516-.5256z'
            fill='#fff'
            fillRule='evenodd'
        />
        <path
            clipRule='evenodd'
            // eslint-disable-next-line max-len
            d='m9.3041 20.2812c.3154-.0416.6344.0438.8867.2376l1.0788.8279c.4307.3303 1.0295.3303 1.4603 0l1.0787-.8279c.2524-.1938.5714-.2792.8868-.2376l1.3487.1776c.538.0708 1.0566-.2284 1.2647-.7296l.5196-1.2563c.1213-.2942.3549-.5278.6491-.6492l1.2564-.5195c.5014-.2078.8007-.7266.7295-1.2648l-.1776-1.3487c-.0416-.3154.0439-.6344.2376-.8867l.828-1.0788c.3302-.4307.3302-1.0295 0-1.4603l-.828-1.0787c-.1937-.25234-.2792-.57134-.2376-.88674l.1776-1.34872c.0708-.53804-.2283-1.05662-.7295-1.26472l-1.2564-.51957c-.2942-.12133-.5278-.35497-.6491-.64916l-.5196-1.25632c-.2078-.50149-.7266-.80077-1.2647-.72955l-1.3487.17759c-.3154.04161-.6344-.04387-.8868-.23759l-1.0787-.82795c-.4308-.33029-1.0296-.33029-1.4603 0l-1.0788.82795c-.2523.19372-.5713.2792-.8867.23759l-1.34872-.17759c-.53804-.07079-1.05663.22835-1.26472.72955l-.51957 1.25632c-.12133.29419-.35498.52783-.64916.64916l-1.25632.51957c-.50149.20776-.80077.72659-.72955 1.26472l.17758 1.34872c.04161.3154-.04386.6344-.23758.88674l-.82795 1.0787c-.33029.4308-.33029 1.0296 0 1.4603l.82795 1.0788c.19319.252.27958.5711.23758.8867l-.17758 1.3487c-.07079.5381.22835 1.0567.72955 1.2648l1.25632.5195c.29398.1212.52797.3552.64916.6492l.51957 1.2563c.20776.5015.72659.8008 1.26472.7296z'
            fill='#1f6aed'
            fillRule='evenodd'
        />
        <path
            d='m8.39941 12.1158 2.75499 2.8798 4.4446-5.39965'
            stroke='#fff'
            strokeLinecap='round'
            strokeLinejoin='round'
            strokeWidth='2'
        />
    </svg>
);

export const VerificationExample = () => (
    <div className={b()}>
        <div className={b('title')}>{i18n('Verification.example.title.v2')}</div>
        <div className={b('user')}>
            <div className={b('avatar')} />
            <div className={b('info')}>
                <div className={b('name')}>
                    {i18n('Verification.example.name')}
                    <div className={b('mark')}>
                        <VerifiedMark />
                    </div>
                </div>
                <div className={b('subtitle')}>{i18n('Verification.example.subtitle')}</div>
            </div>
        </div>
    </div>
);
