import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Input} from '@components/Input';
import {Popup} from '@components/Popup';
import {cn} from '@bem-react/classname';

import './VerificationField.styl';

const b = cn('VerificationField');

// eslint-disable max-len
const TooltipIcon = () => (
    <svg fill='none' height='12' viewBox='0 0 12 12' width='12' xmlns='http://www.w3.org/2000/svg'>
        <g fill='#999'>
            <path
                // eslint-disable-next-line max-len
                d='m5.99961 10.5001c1.19347 0 2.33807-.4741 3.18198-1.31802s1.31801-1.98851 1.31801-3.18198c0-1.19348-.4741-2.33807-1.31801-3.18198-.84391-.84392-1.98851-1.31802-3.18198-1.31802-1.19348 0-2.33807.4741-3.18198 1.31802-.84391.84391-1.31802 1.9885-1.31802 3.18198 0 1.19347.47411 2.33806 1.31802 3.18198s1.9885 1.31802 3.18198 1.31802zm0 .9c-1.43217 0-2.80568-.5689-3.81838-1.58163-1.01269-1.01269-1.581621-2.3862-1.581621-3.81837s.568931-2.80568 1.581621-3.81838c1.0127-1.0127 2.38621-1.581622 3.81838-1.581622s2.80568.568922 3.81837 1.581622c1.01272 1.0127 1.58162 2.38621 1.58162 3.81838s-.5689 2.80568-1.58162 3.81837c-1.01269 1.01273-2.3862 1.58163-3.81837 1.58163z'
            />
            <path
                // eslint-disable-next-line max-len
                d='m4.19922 4.632c.036-.936.66-1.632 1.824-1.632 1.062 0 1.776.636 1.776 1.518 0 .624-.312 1.068-.84 1.386-.522.312-.672.528-.672.936v.24h-.828l-.006-.3c-.018-.588.222-.96.78-1.29.48-.294.654-.528.654-.936 0-.444-.36-.768-.906-.768-.558 0-.912.324-.948.846zm1.722 4.368c-.366 0-.618-.246-.618-.618 0-.378.252-.624.618-.624.372 0 .618.246.618.624 0 .372-.246.618-.618.618z'
            />
        </g>
    </svg>
);

export class VerificationField extends Component {
    ref = React.createRef();
    state = {
        isTooltipOpen: false
    };
    toggleTooltip = () => {
        this.setState({isTooltipOpen: !this.state.isTooltipOpen});
    };
    closeTooltip = () => {
        if (this.state.isTooltipOpen) {
            this.setState({isTooltipOpen: false});
        }
    };
    onChange = ({target} = {}) => {
        const {onChange} = this.props;

        if (onChange && target) {
            onChange(target.value);
        }
    };
    render() {
        const {title, tooltip, value, onChange, readOnly, name, error, errorSource, dataT = ''} = this.props;
        const {isTooltipOpen} = this.state;

        return (
            <div className={b()} data-t={`verification:field:${dataT}`}>
                <div className={b('title')}>
                    {title}
                    {Boolean(tooltip) && (
                        <div className={b('tooltip')} onClick={this.toggleTooltip} ref={this.ref}>
                            <TooltipIcon />
                            <Popup
                                visible={isTooltipOpen}
                                directions={['bottom-center', 'bottom-left', 'bottom-right']}
                                hasTail={true}
                                target='anchor'
                                anchor={this.ref}
                                zIndex={9999}
                                view='black'
                                onClose={this.closeTooltip}
                            >
                                <div className={b('popup')}>{tooltip}</div>
                            </Popup>
                        </div>
                    )}
                </div>
                {readOnly ? (
                    <div className={b('readonly')} data-t={`verification:field:${dataT}:readonly`}>
                        {value}
                    </div>
                ) : (
                    <Input
                        value={value}
                        hasClear={Boolean(onChange)}
                        onChange={this.onChange}
                        name={name}
                        state={error && error.source === errorSource && 'error'}
                        hint={error && error.source === errorSource && error.text}
                        autoComplete='off'
                        dataT={dataT}
                    />
                )}
            </div>
        );
    }
}

VerificationField.propTypes = {
    title: PropTypes.string.isRequired,
    dataT: PropTypes.string,
    name: PropTypes.string,
    tooltip: PropTypes.string,
    value: PropTypes.string,
    onChange: PropTypes.func,
    readOnly: PropTypes.bool,
    error: PropTypes.object,
    errorSource: PropTypes.string
};
