import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {VerificationField} from '../VerificationField';
import {VerificationPhoneButton, VerificationEmailButton, VerificationChangeButton} from '../../buttons';

import './VerificationFields.styl';

const b = cn('VerificationFields');

export const VerificationFields = ({isPplMode, user, phone, email, error, setEmail, setEmailAndConfirm, setPhone}) => (
    <div className={b()} data-t='verification:form'>
        <div className={b('field')} data-t='verification:form:field:personal-info'>
            <VerificationField
                title={i18n('Verification.fields.fullname')}
                tooltip={i18n('Verification.fields.fullname.tooltip.v2')}
                value={user.name}
                readOnly={true}
                dataT='personal-info'
            />
        </div>
        <div className={b('button')} data-t='verification:form:button:personal-info'>
            <VerificationChangeButton href='/profile/personal-info' dataT='personal-info' />
        </div>
        {!isPplMode && (
            <>
                <div className={b('field')} data-t='verification:form:field:display-name'>
                    <VerificationField
                        title={i18n('Verification.fields.publicName.v2')}
                        tooltip={i18n('Verification.fields.publicName.tooltip.v2')}
                        value={user.publicName}
                        readOnly={true}
                        dataT='display-name'
                    />
                </div>
                <div className={b('button')} data-t='verification:form:button:display-name'>
                    <VerificationChangeButton href='/profile/display-name' dataT='display-name' />
                </div>
                <div className={b('field')} data-t='verification:form:field:publicId'>
                    <VerificationField
                        title={i18n('Verification.fields.publicAdress.v2')}
                        tooltip={i18n('Verification.fields.publicAdress.tooltip.v2').replace('%1', user.publicId)}
                        readOnly={true}
                        value={user.publicId}
                        dataT='publicId'
                    />
                </div>
                <div className={b('button')} data-t='verification:form:button:publicId'>
                    <VerificationChangeButton href='/profile/publicid' dataT='publicId' />
                </div>
                <div className={b('field')} data-t='verification:form:field:phone'>
                    <VerificationField
                        title={i18n('Verification.fields.phone')}
                        tooltip={i18n('Verification.fields.phone.tooltip.v2')}
                        value={phone.value}
                        onChange={setPhone}
                        error={error}
                        errorSource='phone_button'
                        readOnly={phone.isConfirmed}
                        dataT='phone'
                    />
                </div>
                <div className={b('button', {big: true})} data-t='verification:form:button:phone'>
                    <VerificationPhoneButton text={i18n('Frontend.confirm.operation')} />
                </div>
            </>
        )}
        {!isPplMode ? (
            <>
                <div className={b('field')} data-t='verification:form:field:email'>
                    <VerificationField
                        title={i18n('Verification.fields.email')}
                        tooltip={i18n('Verification.fields.email.tooltip.v2')}
                        value={email.value}
                        onChange={setEmail}
                        error={error}
                        errorSource='email_button'
                        readOnly={email.isConfirmed}
                        dataT='email'
                    />
                </div>
                <div className={b('button', {big: true})} data-t='verification:form:field:email'>
                    <VerificationEmailButton text={i18n('Verification.fields.email.button')} />
                </div>
            </>
        ) : (
            <div className={b('field')} data-t='verification:form:field:email'>
                <VerificationField
                    title={i18n('Verification.fields.email.ppl')}
                    value={email.value}
                    onChange={setEmailAndConfirm}
                    error={error}
                    errorSource='email_button'
                    readOnly={false}
                    dataT='email'
                />
            </div>
        )}
    </div>
);

VerificationFields.propTypes = {
    isPplMode: PropTypes.bool,
    user: PropTypes.shape({
        name: PropTypes.string,
        publicName: PropTypes.string,
        publicId: PropTypes.string
    }),
    phone: PropTypes.shape({
        value: PropTypes.string,
        isConfirmed: PropTypes.bool
    }),
    email: PropTypes.shape({
        value: PropTypes.string,
        isConfirmed: PropTypes.bool
    }),
    error: PropTypes.object,
    setEmail: PropTypes.func,
    setEmailAndConfirm: PropTypes.func,
    setPhone: PropTypes.func
};
