import {connect} from 'react-redux';

import {VerificationFields as Fields} from './VerificationFields';
import {setEmail, setEmailAndConfirm, setPhone} from '../../api';

const mapStateToProps = ({verification}) => {
    const {isPplMode, user, phone, email, error} = verification || {};

    return {isPplMode, user, phone, email, error};
};

const mapDispatchToProps = {setEmail, setEmailAndConfirm, setPhone};

export const VerificationFields = connect(mapStateToProps, mapDispatchToProps)(Fields);
