import React from 'react';
import PropTypes from 'prop-types';
import {Title} from '@components/Title';
import {Button} from '@components/Button';
import {VerificationLabel} from '../VerificationLabel';
import {VerificationTextarea} from '../VerificationTextarea';
import {VerificationSocials} from '../VerificationSocials';
import {VerificationFields} from '../VerificationFields';
import {VerificationCheckboxes} from '../VerificationCheckboxes';
import {VerificationSendButton, VerificationPhotoButton, VerificationSocialsButton} from '../../buttons';
import {cn} from '@bem-react/classname';

import './VerificationForm.styl';

const b = cn('VerificationForm');

export const VerificationForm = ({isPplMode, isLoggedIn, authLink, csrf, trackId, login, serpUri, error}) => (
    <div className={b({isLoggedIn})} data-t='verification:form'>
        <Title size='xl'>{i18n('Verification.form.title.v2')}</Title>
        <div className={b('wrap')} data-t='verification:form:wrap'>
            {isLoggedIn ? (
                <div className={b('form')}>
                    <input type='hidden' name='csrf' value={csrf} />
                    <input type='hidden' name='track_id' value={trackId} />
                    <input type='hidden' name='login' value={login} />
                    {isPplMode && <input type='hidden' name='serp_uri' value={serpUri} />}
                    <div className={b('block')} data-t='verification:form:block:fields'>
                        <VerificationLabel index={1} text={i18n('Verification.form.label.data.v2')} isRequired={true} />
                        <VerificationFields />
                    </div>
                    <div className={b('block')} data-t='verification:form:block:photo'>
                        <VerificationLabel
                            index={2}
                            text={
                                isPplMode
                                    ? i18n('Verification.form.label.photo.v2.ppl')
                                    : i18n('Verification.form.label.photo.v2')
                            }
                            description={i18n('Verification.form.label.photo.description.v2')}
                            isRequired={true}
                        />
                        <div className={b('button')}>
                            <VerificationPhotoButton />
                        </div>
                        {error && error.source === 'photo' && (
                            <div className={b('error')}>{i18n('_AUTH_.avatar.file-size')}</div>
                        )}
                    </div>
                    <div className={b('block')} data-t='verification:form:block:socials'>
                        <VerificationLabel
                            index={3}
                            text={i18n('Verification.form.label.socials.v2')}
                            description={i18n('Verification.form.label.socials.description.v2')}
                            isRequired={!isPplMode}
                        />
                        <div className={b('socials')}>
                            <VerificationSocials />
                        </div>
                        <div className={b('button')}>
                            <VerificationSocialsButton />
                        </div>
                    </div>
                    <div className={b('block')} data-t='verification:form:block:info'>
                        <VerificationLabel
                            index={4}
                            text={
                                isPplMode
                                    ? i18n('Verification.form.label.info.ppl')
                                    : i18n('Verification.form.label.info.v2')
                            }
                            isRequired={!isPplMode}
                        />
                        <VerificationTextarea />
                    </div>
                    <VerificationCheckboxes />
                    <div className={b('button')}>
                        <VerificationSendButton />
                    </div>
                </div>
            ) : (
                <>
                    <VerificationLabel index={1} text={i18n('Verification.form.label.login.v2')} />
                    <VerificationLabel
                        index={2}
                        text={
                            <span
                                dangerouslySetInnerHTML={{
                                    __html: i18n('Verification.form.label.fio').replace(
                                        '%1',
                                        `<b>${i18n('Verification.form.label.fio.name')}</b>`
                                    )
                                }}
                            />
                        }
                    />
                    <VerificationLabel
                        index={3}
                        text={
                            <span
                                dangerouslySetInnerHTML={{
                                    __html: i18n('Verification.form.label.public')
                                        .replace('%1', `<b>${i18n('Verification.form.label.public.name')}</b>`)
                                        .replace('%2', `<b>${i18n('Verification.form.label.public.adress')}</b>`)
                                }}
                            />
                        }
                    />
                    {!isPplMode && (
                        <VerificationLabel
                            index={4}
                            text={
                                <span
                                    dangerouslySetInnerHTML={{
                                        __html: i18n('Verification.form.label.mobile').replace(
                                            '%1',
                                            `<a href='/profile/phones' class='${b('link')}'>${i18n(
                                                'Verification.form.label.mobile.link'
                                            )}</a>`
                                        )
                                    }}
                                />
                            }
                        />
                    )}
                    <VerificationLabel
                        index={isPplMode ? 4 : 5}
                        text={
                            <span
                                dangerouslySetInnerHTML={{
                                    __html: i18n('Verification.form.label.email').replace(
                                        '%1',
                                        `<b>${i18n('Verification.form.label.email.restore')}</b>`
                                    )
                                }}
                            />
                        }
                    />
                    <VerificationLabel
                        index={isPplMode ? 5 : 6}
                        text={<b>{i18n('Verification.form.label.return')}</b>}
                    />
                </>
            )}
        </div>
        {!isLoggedIn && (
            <div className={b('button')}>
                <Button
                    view='action'
                    width='max'
                    type='button'
                    size='m'
                    as='a'
                    href={authLink}
                    dataT='verification:login'
                >
                    {i18n('Verification.form.button.login')}
                </Button>
            </div>
        )}
    </div>
);

VerificationForm.propTypes = {
    isPplMode: PropTypes.bool,
    isLoggedIn: PropTypes.bool.isRequired,
    error: PropTypes.object,
    authLink: PropTypes.string,
    csrf: PropTypes.string,
    trackId: PropTypes.string,
    login: PropTypes.string,
    serpUri: PropTypes.string
};
