import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';

import './VerificationLabel.styl';

const b = cn('VerificationLabel');

export const VerificationLabel = ({index, text, subText, isRequired, description}) => (
    <div className={b()}>
        <div className={b('text')}>
            {index}. {text}
            {isRequired && <span className={b('required')}>*</span>}
            {Boolean(subText) && <div className={b('sutext')}>{subText}</div>}
        </div>
        {Boolean(description) && <div className={b('description')}>{description}</div>}
    </div>
);

VerificationLabel.propTypes = {
    index: PropTypes.number.isRequired,
    text: PropTypes.string.isRequired,
    subText: PropTypes.string,
    isRequired: PropTypes.bool,
    description: PropTypes.string
};
