import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Modal} from '@components/Modal';
import {Button} from '@components/Button';
import {cn} from '@bem-react/classname';

import './VerificationModal.styl';

const b = cn('VerificationModal');

export class VerificationModal extends Component {
    onAcceptClick = (e) => {
        const {onAccept} = this.props;

        e.preventDefault();
        onAccept();
    };
    render() {
        const {
            visible,
            closeModal,
            title,
            text,
            buttonText,
            children,
            isAcceptDisabled,
            isTextCentered,
            isBigButtons,
            showCancelButton
        } = this.props;

        return (
            <Modal visible={visible} onClose={closeModal} onCloserClick={closeModal}>
                <div className={b({isTextCentered, isBigButtons})}>
                    <div className={b('title')}>{title}</div>
                    <div className={b('text')} dangerouslySetInnerHTML={{__html: text}} />
                    {children && <div className={b('content')}>{children}</div>}
                    <div className={b('buttons')}>
                        {showCancelButton && (
                            <div className={b('button')}>
                                <Button
                                    size='m'
                                    width='max'
                                    view='clear'
                                    onClick={closeModal}
                                    dataT='verification:cancel'
                                >
                                    {i18n('_AUTH_.common.cancel')}
                                </Button>
                            </div>
                        )}
                        <div className={b('button')}>
                            <Button
                                size='m'
                                width='max'
                                view='action'
                                onClick={this.onAcceptClick}
                                disabled={isAcceptDisabled}
                                dataT='verification:confirm'
                            >
                                {buttonText ||
                                    (showCancelButton
                                        ? i18n('Profile.common.confirm')
                                        : i18n('Profile.common.continue'))}
                            </Button>
                        </div>
                    </div>
                </div>
            </Modal>
        );
    }
}

VerificationModal.propTypes = {
    visible: PropTypes.bool,
    isAcceptDisabled: PropTypes.bool,
    isTextCentered: PropTypes.bool,
    isBigButtons: PropTypes.bool,
    showCancelButton: PropTypes.bool,
    closeModal: PropTypes.func,
    onAccept: PropTypes.func,
    title: PropTypes.node,
    children: PropTypes.node,
    text: PropTypes.string,
    buttonText: PropTypes.string
};
