import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';

import './VerificationPhoto.styl';

const b = cn('VerificationPhoto');

export class VerificationPhoto extends Component {
    onCloseClick = () => {
        const {setPhotoSrc, onClose} = this.props;

        setPhotoSrc('');
        onClose();
    };
    render() {
        const {photoSrc} = this.props;

        return (
            <div className={b()} style={{backgroundImage: `url(${photoSrc})`}}>
                <div className={b('close')} onClick={this.onCloseClick}>
                    <div className={b('icon')} />
                </div>
            </div>
        );
    }
}

VerificationPhoto.propTypes = {
    photoSrc: PropTypes.string,
    setPhotoSrc: PropTypes.func,
    onClose: PropTypes.func
};
