import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Input} from '@components/Input';
import {cn} from '@bem-react/classname';

import './VerificationSocials.styl';

const b = cn('VerificationSocials');

const socials = {
    'vk.com': 'vk',
    'facebook.com': 'fb',
    'ok.ru': 'ok',
    'twitter.com': 'tw',
    'www.instagram.com': 'inst',
    'www.tiktok.com': 'tt',
    'www.youtube.com': 'yt'
};

const socialsRegexp = new RegExp(
    `^(https?://)?((${Object.keys(socials)
        .map((social) => social.replace(/[.]/g, '\\.'))
        .join(')|(')}))`
);

class VerificationSocial extends Component {
    state = {socialType: null};
    onClearClick = () => {
        const {removeSocial, index} = this.props;

        removeSocial(index);
    };
    onChange = ({target} = {}) => {
        const {setSocial, index} = this.props;

        if (target) {
            setSocial(target.value, index);
        }
    };
    shouldComponentUpdate(props) {
        const {social} = this.props;

        if (props.social !== social) {
            const regexpExec = socialsRegexp.exec(props.social);
            const socialUrl = regexpExec && regexpExec[2];
            const socialType = socialUrl ? socials[socialUrl] : null;

            if (socialType !== this.state.socialType) {
                this.setState({socialType});
                return false;
            }
        }

        return true;
    }
    render() {
        const {social, index} = this.props;
        const {socialType} = this.state;

        return (
            <div className={b('item')} data-t={`verification:socials:${index}`}>
                <div className={b('icon', {social: socialType})} data-t={`verification:socials:${index}:icon`} />
                <div className={b('input')}>
                    <Input
                        value={social}
                        onChange={this.onChange}
                        hasClear={true}
                        onClearClick={this.onClearClick}
                        name={`social${index}`}
                        dataT={`socials:${index}`}
                        placeholder={i18n('Verification.socials.placeholder')}
                    />
                </div>
            </div>
        );
    }
}

export const VerificationSocials = ({socials, setSocial, removeSocial}) => (
    <div className={b()} data-t='verification:socials'>
        {socials.map((social, index) => (
            <VerificationSocial
                social={social}
                index={index}
                setSocial={setSocial}
                removeSocial={removeSocial}
                key={index}
            />
        ))}
    </div>
);

VerificationSocial.propTypes = {
    social: PropTypes.string,
    index: PropTypes.number,
    setSocial: PropTypes.func,
    removeSocial: PropTypes.func
};

VerificationSocials.propTypes = {
    socials: PropTypes.arrayOf(PropTypes.string),
    setSocial: PropTypes.func,
    removeSocial: PropTypes.func
};
