import React from 'react';
import PropTypes from 'prop-types';
import {TextArea} from '@components/TextArea';

export class VerificationTextarea extends React.Component {
    onChange = ({target} = {}) => {
        const {setReason} = this.props;

        if (target) {
            setReason(target.value);
        }
    };
    render() {
        const {reason} = this.props;

        return (
            <TextArea
                value={reason}
                onChange={this.onChange}
                size='l'
                width='max'
                name='additional_info'
                dataT='verification:textarea'
            />
        );
    }
}

VerificationTextarea.propTypes = {
    reason: PropTypes.string,
    setReason: PropTypes.func
};
