import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Input} from '@components/Input';
import {Link} from '@components/Link';
import {getError} from '@blocks/utils';
import {VerificationModal} from '../../components/VerificationModal';
import {cn} from '@bem-react/classname';

import './VerificationEmailModal.styl';

const b = cn('VerificationEmailModal');

export class VerificationEmailModal extends Component {
    state = {
        code: '',
        isAccepted: false,
        error: null
    };
    componentDidUpdate(props) {
        const {visible, setEmailConfirmInProgress, isConfirmInProgress} = this.props;

        if (!props.visible && visible) {
            if (!isConfirmInProgress) {
                setEmailConfirmInProgress();
            }
            this.setCode('');
        }
    }
    removeError = () => {
        const {error, setError} = this.props;

        if (error && error.source === 'email_modal') {
            setError(null);
        }
    };
    onCodeChange = (e) => {
        if (e && e.target) {
            this.setCode(e.target.value);
        }
    };
    setCode = (code) => {
        this.removeError();
        this.setState({code});
    };
    onAcceptClick = () => {
        const {postEmailCommit} = this.props;
        const {code} = this.state;

        this.removeError();
        postEmailCommit(code)
            .done(this.setAccepted)
            .fail(this.onFailCommit);
    };
    onFailCommit = ({errors}) => {
        const {setError} = this.props;
        const {text, code} = getError('email_code', errors[0]);

        setError({code, text, source: 'email_modal'});
    };
    onFailResend = ({errors}) => {
        const {setError} = this.props;
        const {text, code} = getError('email', errors[0]);

        setError({code, text, source: 'email_modal'});
    };
    setAccepted = () => this.setState({isAccepted: true});
    onResendClick = () => {
        const {postCreateEmail} = this.props;

        this.removeError();
        postCreateEmail(null, this.onFailResend);
    };
    maybeRenderContent = () => {
        const {error} = this.props;
        const {code, isAccepted} = this.state;

        if (isAccepted) {
            return null;
        }

        return (
            <div className={b()} data-t='verification:modal:email'>
                <div className={b('input')}>
                    <Input
                        onChange={this.onCodeChange}
                        dataT='email'
                        value={code}
                        autoComplete='off'
                        state={error && error.source === 'email_modal' && 'error'}
                        hint={error && error.source === 'email_modal' && error.text}
                        placeholder={i18n('Verification.email-modal.placeholder')}
                        name='emailCode'
                    />
                </div>
                <div className={b('button')}>
                    <Link size='m' width='max' onClick={this.onResendClick} data-t='verification:modal:email:resend'>
                        {i18n('Verification.email-modal.resend')}
                    </Link>
                </div>
            </div>
        );
    };

    render() {
        const {visible, value, closeModal} = this.props;
        const {code, isAccepted} = this.state;

        return (
            <VerificationModal
                visible={visible}
                title={
                    isAccepted
                        ? i18n('Verification.email-modal.title.accepted')
                        : i18n('Verification.email-modal.title')
                }
                text={
                    isAccepted
                        ? i18n('Verification.email-modal.text.accepted')
                        : i18n('Verification.email-modal.text').replace('%1', `<b>${value}</b>`)
                }
                closeModal={closeModal}
                onAccept={isAccepted ? closeModal : this.onAcceptClick}
                isAcceptDisabled={!(isAccepted || code)}
                showCancelButton={!isAccepted}
            >
                {this.maybeRenderContent()}
            </VerificationModal>
        );
    }
}

VerificationEmailModal.propTypes = {
    visible: PropTypes.bool,
    isConfirmInProgress: PropTypes.bool,
    value: PropTypes.string,
    closeModal: PropTypes.func,
    title: PropTypes.node,
    text: PropTypes.node,
    children: PropTypes.node,
    error: PropTypes.object,
    postCreateEmail: PropTypes.func,
    postEmailCommit: PropTypes.func,
    setEmailConfirmInProgress: PropTypes.func,
    setError: PropTypes.func
};
