import {connect} from 'react-redux';
import {VerificationEmailModal as Modal} from './VerificationEmailModal';
import {postEmailCommit, postCreateEmail, setEmailConfirmInProgress, setError} from '../../api';

const mapStateToProps = ({verification}) => {
    const {email: {value = '', isConfirmInProgress, isConfirmed} = {}, error} = verification || {};

    return {value, isConfirmInProgress, isConfirmed, error};
};

const mapDispatchToProps = {postEmailCommit, postCreateEmail, setEmailConfirmInProgress, setError};

export const VerificationEmailModal = connect(mapStateToProps, mapDispatchToProps)(Modal);
